/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.model;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.client.render.RenderBladeshroomCap;
import com.mushroom.midnight.client.render.RenderCloud;
import com.mushroom.midnight.client.render.RenderCrystalBug;
import com.mushroom.midnight.client.render.RenderDeceitfulSnapper;
import com.mushroom.midnight.client.render.RenderHunter;
import com.mushroom.midnight.client.render.RenderNightStag;
import com.mushroom.midnight.client.render.RenderNova;
import com.mushroom.midnight.client.render.RenderPenumbrian;
import com.mushroom.midnight.client.render.RenderRift;
import com.mushroom.midnight.client.render.RenderRifter;
import com.mushroom.midnight.client.render.RenderSkulk;
import com.mushroom.midnight.client.render.RenderStinger;
import com.mushroom.midnight.client.render.RenderTreeHopper;
import com.mushroom.midnight.client.render.TEISRBomb;
import com.mushroom.midnight.client.render.TEISRShield;
import com.mushroom.midnight.common.block.BlockMidnightChest;
import com.mushroom.midnight.common.entity.EntityCloud;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.entity.creature.EntityCrystalBug;
import com.mushroom.midnight.common.entity.creature.EntityDeceitfulSnapper;
import com.mushroom.midnight.common.entity.creature.EntityHunter;
import com.mushroom.midnight.common.entity.creature.EntityNightStag;
import com.mushroom.midnight.common.entity.creature.EntityNova;
import com.mushroom.midnight.common.entity.creature.EntityPenumbrian;
import com.mushroom.midnight.common.entity.creature.EntityRifter;
import com.mushroom.midnight.common.entity.creature.EntitySkulk;
import com.mushroom.midnight.common.entity.creature.EntityStinger;
import com.mushroom.midnight.common.entity.creature.EntityTreeHopper;
import com.mushroom.midnight.common.entity.projectile.EntityBladeshroomCap;
import com.mushroom.midnight.common.entity.projectile.EntitySporeBomb;
import com.mushroom.midnight.common.entity.projectile.EntityThrownGeode;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.registry.ModItems;
import com.mushroom.midnight.common.tile.base.TileEntityMidnightChest;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="midnight", value={Side.CLIENT})
public class ModModelRegistry {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final int DEFAULT_GRASS_COLOR = 12553932;
    private static final int DEFAULT_FOLIAGE_COLOR = 9399740;

    @SubscribeEvent
    public static void onRegisterModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityRift.class, RenderRift::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityRifter.class, RenderRifter::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHunter.class, RenderHunter::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBladeshroomCap.class, RenderBladeshroomCap::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityNova.class, RenderNova::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCrystalBug.class, RenderCrystalBug::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPenumbrian.class, RenderPenumbrian::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTreeHopper.class, RenderTreeHopper::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStinger.class, RenderStinger::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityNightStag.class, RenderNightStag::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDeceitfulSnapper.class, RenderDeceitfulSnapper::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySkulk.class, RenderSkulk::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityThrownGeode.class, manager -> new RenderSnowball(manager, ModItems.GEODE, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntitySporeBomb.class, manager -> new RenderSnowball<EntitySporeBomb>(manager, ModItems.SPORE_BOMB, Minecraft.func_71410_x().func_175599_af()){

            @Nonnull
            public ItemStack getStackToRender(EntitySporeBomb entity) {
                return entity.getBombStack();
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityCloud.class, RenderCloud::new);
        ModItems.getItems().stream().filter(i -> i instanceof IModelProvider).forEach(ModModelRegistry::registerItemModel);
        ModBlocks.getBlocks().stream().filter(b -> b instanceof IModelProvider).forEach(ModModelRegistry::registerBlockModel);
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SHADOWROOT_LEAVES, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DARK_WILLOW_LEAVES, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SHADOWROOT_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DARK_WILLOW_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DEAD_WOOD_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.TENEBRUM_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.NIGHTSHROOM_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DEWSHROOM_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.VIRIDSHROOM_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SHADOWROOT_SAPLING, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSapling.field_176479_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DARK_WILLOW_SAPLING, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSapling.field_176479_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DOUBLE_DEWSHROOM, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSapling.field_176479_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DOUBLE_NIGHTSHROOM, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSapling.field_176479_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DOUBLE_VIRIDSHROOM, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSapling.field_176479_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DOUBLE_BOGSHROOM, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSapling.field_176479_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.MIASMA, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidClassic.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DARK_WATER, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidClassic.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.NIGHTSTONE_WALL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.NIGHTSTONE_BRICK_WALL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.TRENCHSTONE_WALL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.TRENCHSTONE_BRICK_WALL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.ROCKSHROOM_BRICKS_WALL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SHADOWROOT_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DEAD_WOOD_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DARK_WILLOW_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.DEWSHROOM_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.VIRIDSHROOM_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.NIGHTSHROOM_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SHADOWROOT_CHEST, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockMidnightChest.field_176459_a}).func_178441_a());
        final TileEntityMidnightChest shadowrootChest = new TileEntityMidnightChest(BlockMidnightChest.ChestModel.SHADOWROOT);
        Item.func_150898_a((Block)ModBlocks.SHADOWROOT_CHEST).setTileEntityItemStackRenderer(new TileEntityItemStackRenderer(){

            public void func_179022_a(ItemStack stack) {
                TileEntityRendererDispatcher.field_147556_a.func_192855_a((TileEntity)shadowrootChest, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            }
        });
        ModItems.ROCKSHROOM_SHIELD.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new TEISRShield());
        ModItems.SPORE_BOMB.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new TEISRBomb());
        ModItems.ADVANCEMENT_HIGHNESS.setTileEntityItemStackRenderer(new TileEntityItemStackRenderer(){
            private EntityNightStag entity;

            @SideOnly(value=Side.CLIENT)
            public void func_179022_a(ItemStack stack) {
                if (this.entity == null && Minecraft.func_71410_x().field_71441_e != null) {
                    this.entity = new EntityNightStag((World)Minecraft.func_71410_x().field_71441_e);
                }
                if (this.entity != null) {
                    try {
                        RenderNightStag render = new RenderNightStag(Minecraft.func_71410_x().func_175598_ae());
                        render.func_76986_a((EntityLiving)this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static void onInit() {
        BlockColors blockColors = MC.func_184125_al();
        ItemColors itemColors = MC.getItemColors();
        blockColors.func_186722_a(ModModelRegistry::computeGrassColor, new Block[]{ModBlocks.MIDNIGHT_GRASS});
        itemColors.func_186731_a(ModModelRegistry::defaultGrassColor, new Block[]{ModBlocks.MIDNIGHT_GRASS});
        blockColors.func_186722_a(ModModelRegistry::computeFoliageColor, new Block[]{ModBlocks.SHADOWROOT_LEAVES});
        itemColors.func_186731_a(ModModelRegistry::defaultFoliageColor, new Block[]{ModBlocks.SHADOWROOT_LEAVES});
        blockColors.func_186722_a(ModModelRegistry::computeGrassColor, new Block[]{ModBlocks.TALL_MIDNIGHT_GRASS, ModBlocks.DOUBLE_MIDNIGHT_GRASS});
        itemColors.func_186731_a(ModModelRegistry::defaultGrassColor, new Block[]{ModBlocks.TALL_MIDNIGHT_GRASS, ModBlocks.DOUBLE_MIDNIGHT_GRASS});
    }

    private static int computeGrassColor(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        if (world == null || pos == null || !ModModelRegistry.isMidnight()) {
            return 9399740;
        }
        return BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos);
    }

    private static int defaultGrassColor(ItemStack stack, int tintIndex) {
        return 12553932;
    }

    private static int computeFoliageColor(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        if (world == null || pos == null || !ModModelRegistry.isMidnight()) {
            return 9399740;
        }
        return BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos);
    }

    private static int defaultFoliageColor(ItemStack stack, int tintIndex) {
        return 9399740;
    }

    private static boolean isMidnight() {
        return Helper.isMidnightDimension((World)ModModelRegistry.MC.field_71441_e);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerBlockModel(Block block) {
        ResourceLocation identifier = block.getRegistryName();
        Item item = Item.func_150898_a((Block)block);
        if (identifier == null || item == Items.field_190931_a) {
            return;
        }
        Int2ObjectOpenHashMap variants = new Int2ObjectOpenHashMap();
        ((IModelProvider)block).gatherVariants((Int2ObjectMap<String>)variants);
        for (Int2ObjectMap.Entry entry : variants.int2ObjectEntrySet()) {
            int metadata = entry.getIntKey();
            String variant = (String)entry.getValue();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(identifier, variant));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(Item item) {
        ResourceLocation identifier = item.getRegistryName();
        if (identifier == null) {
            return;
        }
        Int2ObjectOpenHashMap variants = new Int2ObjectOpenHashMap();
        ((IModelProvider)item).gatherVariants((Int2ObjectMap<String>)variants);
        for (Int2ObjectMap.Entry entry : variants.int2ObjectEntrySet()) {
            int metadata = entry.getIntKey();
            String variant = (String)entry.getValue();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(identifier, variant));
        }
    }
}

