/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome.config;

import com.google.common.collect.ImmutableMap;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.util.WeightedPool;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;

public class SpawnerConfig {
    public static final SpawnerConfig EMPTY = new SpawnerConfig((ImmutableMap<EnumCreatureType, WeightedPool<Biome.SpawnListEntry>>)ImmutableMap.of(), 0.0f);
    private final ImmutableMap<EnumCreatureType, WeightedPool<Biome.SpawnListEntry>> spawnPools;
    private final float spawnChance;

    private SpawnerConfig(ImmutableMap<EnumCreatureType, WeightedPool<Biome.SpawnListEntry>> spawnPools, float spawnChance) {
        this.spawnPools = spawnPools;
        this.spawnChance = spawnChance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public WeightedPool<Biome.SpawnListEntry> getPool(EnumCreatureType creatureType) {
        return (WeightedPool)this.spawnPools.getOrDefault((Object)creatureType, WeightedPool.empty());
    }

    public float getSpawnChance() {
        return this.spawnChance;
    }

    public boolean isEmpty() {
        return this.spawnPools.isEmpty() || this.spawnChance <= 0.0f;
    }

    public static class Builder {
        private final Map<EnumCreatureType, WeightedPool<Biome.SpawnListEntry>> spawnPools = new HashMap<EnumCreatureType, WeightedPool<Biome.SpawnListEntry>>();
        private float spawnChance = 0.1f;

        Builder() {
        }

        public Builder extendsFrom(SpawnerConfig config) {
            this.spawnPools.putAll((Map<EnumCreatureType, WeightedPool<Biome.SpawnListEntry>>)config.spawnPools);
            this.spawnChance = config.spawnChance;
            return this;
        }

        public Builder withCreature(Biome.SpawnListEntry entry) {
            return this.withEntity(EnumCreatureType.CREATURE, entry);
        }

        public Builder withMonster(Biome.SpawnListEntry entry) {
            return this.withEntity(Midnight.MIDNIGHT_MOB, entry);
        }

        public Builder withAmbientCreature(Biome.SpawnListEntry entry) {
            return this.withEntity(Midnight.MIDNIGHT_AMBIENT, entry);
        }

        public Builder withWaterCreature(Biome.SpawnListEntry entry) {
            return this.withEntity(EnumCreatureType.WATER_CREATURE, entry);
        }

        public Builder withEntity(EnumCreatureType creatureType, Biome.SpawnListEntry entry) {
            this.spawnPools.computeIfAbsent(creatureType, p -> new WeightedPool()).add(entry);
            return this;
        }

        public Builder withSpawnChance(float chance) {
            this.spawnChance = chance;
            return this;
        }

        public SpawnerConfig build() {
            return new SpawnerConfig(ImmutableMap.copyOf(this.spawnPools), this.spawnChance);
        }
    }
}

