/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.registry.ModTabs;
import com.mushroom.midnight.common.util.DirectionalBounds;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDeceitfulMoss
extends Block
implements IModelProvider {
    public static final PropertyEnum<EnumFacing> FACING = BlockDirectional.field_176387_N;
    private static final DirectionalBounds BOUNDS = new DirectionalBounds(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);

    public BlockDeceitfulMoss() {
        super(Material.field_151585_k, MapColor.field_193571_W);
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(ModTabs.DECORATION_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.DOWN));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS.get((EnumFacing)state.func_177229_b(FACING));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return BlockDeceitfulMoss.canAttachTo(world, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return Arrays.stream(EnumFacing.field_82609_l).anyMatch(f -> BlockDeceitfulMoss.canAttachTo(world, pos, f));
    }

    private static boolean canAttachTo(World world, BlockPos pos, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return false;
        }
        BlockPos surfacePos = pos.func_177972_a(facing.func_176734_d());
        IBlockState surfaceState = world.func_180495_p(surfacePos);
        return surfaceState.isSideSolid((IBlockAccess)world, surfacePos, facing);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)(BlockDeceitfulMoss.canAttachTo(world, pos, facing) ? facing : EnumFacing.DOWN));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.tryDrop(world, pos, state) && !BlockDeceitfulMoss.canAttachTo(world, pos, (EnumFacing)state.func_177229_b(FACING))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    private boolean tryDrop(World world, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(world, pos)) {
            return true;
        }
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a(FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b(FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        IBlockState neighbor = world.func_180495_p(pos.func_177972_a(side));
        return neighbor.func_177230_c() != this && super.func_176225_a(state, world, pos, side);
    }
}

