/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.block.GeneratablePlant;
import com.mushroom.midnight.common.block.PlantBehaviorType;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.registry.ModTabs;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMidnightPlant
extends BlockBush
implements IModelProvider,
IShearable,
GeneratablePlant {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    private final PlantBehaviorType behaviorType;
    private final boolean glowing;

    public BlockMidnightPlant(PlantBehaviorType behaviorType, boolean glowing) {
        super(behaviorType.getMaterial(), MapColor.field_193571_W);
        this.behaviorType = behaviorType;
        this.glowing = glowing;
        if (this.glowing) {
            this.func_149715_a(0.8f);
        }
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(ModTabs.DECORATION_TAB);
    }

    public BlockMidnightPlant(boolean glowing) {
        this(PlantBehaviorType.FLOWER, glowing);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    protected boolean func_185514_i(IBlockState state) {
        return Helper.isGroundForMidnightPlant(state.func_177230_c());
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return this.func_185514_i(world.func_180495_p(pos.func_177977_b()));
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.behaviorType.isShearable();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        if (this.behaviorType.isShearable()) {
            return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this));
        }
        return Collections.emptyList();
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return this.behaviorType.isReplacable();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.behaviorType.isShearable() ? Items.field_190931_a : super.func_180660_a(state, rand, fortune);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.glowing ? layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT : super.canRenderInLayer(state, layer);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!this.glowing) {
            return super.func_185484_c(state, source, pos);
        }
        if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT) {
            return source.func_175626_b(pos, 0);
        }
        int skyLight = 14;
        int blockLight = 14;
        return skyLight << 20 | blockLight << 4;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 100;
    }
}

