/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.google.common.collect.ImmutableList;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.RifterCapturable;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.entity.IRiftTraveler;
import com.mushroom.midnight.common.entity.RiftTravelEntry;
import com.mushroom.midnight.common.entity.TargetIdleTracker;
import com.mushroom.midnight.common.entity.navigation.CustomPathNavigateGround;
import com.mushroom.midnight.common.entity.task.EntityTaskRifterCapture;
import com.mushroom.midnight.common.entity.task.EntityTaskRifterKeepNearRift;
import com.mushroom.midnight.common.entity.task.EntityTaskRifterMelee;
import com.mushroom.midnight.common.entity.task.EntityTaskRifterReturn;
import com.mushroom.midnight.common.entity.task.EntityTaskRifterTeleport;
import com.mushroom.midnight.common.entity.task.EntityTaskRifterTransport;
import com.mushroom.midnight.common.entity.util.DragSolver;
import com.mushroom.midnight.common.entity.util.EntityReference;
import com.mushroom.midnight.common.event.RifterCaptureEvent;
import com.mushroom.midnight.common.event.RifterReleaseEvent;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.network.MessageCaptureEntity;
import com.mushroom.midnight.common.registry.ModEffects;
import com.mushroom.midnight.common.registry.ModLootTables;
import com.mushroom.midnight.common.registry.ModSounds;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityRifter
extends EntityMob
implements IRiftTraveler,
IEntityAdditionalSpawnData {
    public static final float HOME_SCALE_MODIFIER = 1.4f;
    private static final UUID SPEED_MODIFIER_ID = UUID.fromString("3b8cda1f-c11d-478b-98b1-6144940c7ba1");
    private static final AttributeModifier HOME_SPEED_MODIFIER = new AttributeModifier(SPEED_MODIFIER_ID, "home_speed_modifier", 0.15, 2);
    private static final UUID ARMOR_MODIFIER_ID = UUID.fromString("8cea53c5-1b5c-4b7c-9c86-192bf255c3d4");
    private static final AttributeModifier HOME_ARMOR_MODIFIER = new AttributeModifier(ARMOR_MODIFIER_ID, "home_armor_modifier", 2.0, 2);
    private static final UUID ATTACK_MODIFIER_ID = UUID.fromString("0e13d84c-52ed-4335-a284-49596533f445");
    private static final AttributeModifier HOME_ATTACK_MODIFIER = new AttributeModifier(ATTACK_MODIFIER_ID, "home_attack_modifier", 3.0, 2);
    public static final int CAPTURE_COOLDOWN = 15;
    private static final double RIFT_SEARCH_RADIUS = 48.0;
    private static final float DROP_DAMAGE_THRESHOLD = 2.0f;
    private final EntityReference<EntityRift> homeRift;
    private final DragSolver dragSolver;
    private final TargetIdleTracker targetIdleTracker = new TargetIdleTracker((EntityLiving)this, 3.0);
    public int captureCooldown;
    public boolean spawnedThroughRift;
    private EntityLivingBase capturedEntity;

    public EntityRifter(World world) {
        super(world);
        this.homeRift = new EntityReference(world);
        this.dragSolver = new DragSolver(this);
        float scaleModifier = Helper.isMidnightDimension(world) ? 1.4f : 1.0f;
        this.func_70105_a(0.6f * scaleModifier, 1.8f * scaleModifier);
        this.field_70138_W = 1.0f;
    }

    protected PathNavigate func_175447_b(World world) {
        return new CustomPathNavigateGround((EntityLiving)this, world);
    }

    public boolean func_70601_bi() {
        return this.func_180425_c().func_177956_o() > this.field_70170_p.func_181545_F() && super.func_70601_bi();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityTaskRifterReturn(this, 1.3));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityTaskRifterKeepNearRift(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityTaskRifterTeleport(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityTaskRifterTransport(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityTaskRifterCapture(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityTaskRifterMelee(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.4, 0.005f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 2, true, false, this::shouldAttack));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 4, true, false, this::shouldAttack));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.targetIdleTracker.update();
            this.applyHomeModifier(SharedMonsterAttributes.field_111263_d, HOME_SPEED_MODIFIER);
            this.applyHomeModifier(SharedMonsterAttributes.field_111264_e, HOME_ATTACK_MODIFIER);
            this.applyHomeModifier(SharedMonsterAttributes.field_188791_g, HOME_ARMOR_MODIFIER);
            if (this.capturedEntity != null && !this.capturedEntity.func_70089_S()) {
                this.setCapturedEntity(null);
            }
            if (this.captureCooldown > 0) {
                --this.captureCooldown;
            }
            if (!Helper.isMidnightDimension(this.field_70170_p)) {
                this.updateHomeRift();
                if (this.field_70173_aa % 20 == 0 && !this.homeRift.isPresent()) {
                    this.func_70097_a(DamageSource.field_76380_i, 2.0f);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K || Midnight.proxy.isClientPlayer((Entity)this.capturedEntity)) {
            this.dragSolver.solveDrag();
        }
        super.func_70636_d();
    }

    public int getTargetIdleTime() {
        return this.targetIdleTracker.getIdleTime();
    }

    public boolean shouldCapture() {
        if (Helper.isMidnightDimension(this.field_70170_p)) {
            return false;
        }
        return this.homeRift.isPresent();
    }

    private void applyHomeModifier(IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance instance = this.func_110148_a(attribute);
        boolean home = Helper.isMidnightDimension(this.field_70170_p);
        if (home != instance.func_180374_a(modifier)) {
            if (home) {
                instance.func_111121_a(modifier);
            } else {
                instance.func_111124_b(modifier);
            }
        }
    }

    private void updateHomeRift() {
        AxisAlignedBB searchBounds;
        List rifts;
        if (this.field_70173_aa % 20 == 0 && !this.homeRift.isPresent() && !(rifts = this.field_70170_p.func_72872_a(EntityRift.class, searchBounds = this.func_174813_aQ().func_186662_g(48.0))).isEmpty()) {
            rifts.sort(Comparator.comparingDouble(arg_0 -> ((EntityRifter)this).func_70068_e(arg_0)));
            this.homeRift.set((EntityRift)((Entity)rifts.get(0)));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity trueSource = source.func_76346_g();
        if (super.func_70097_a(source, amount)) {
            if (trueSource instanceof EntityLivingBase && this.shouldAttack(trueSource) && this.shouldChangeTarget(this.func_70638_az(), (EntityLivingBase)trueSource)) {
                this.func_70624_b((EntityLivingBase)trueSource);
            }
            if (amount > 2.0f) {
                this.setCapturedEntity(null);
            }
            return true;
        }
        return false;
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    private boolean shouldAttack(Entity entity) {
        if (entity == null || RifterCapturable.isCaptured(entity)) {
            return false;
        }
        if (entity instanceof EntityAnimal) {
            return !Helper.isMidnightDimension(entity.field_70170_p);
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70608_bn()) {
            return false;
        }
        return !(entity instanceof EntityRifter);
    }

    private boolean shouldChangeTarget(@Nullable EntityLivingBase from, EntityLivingBase to) {
        if (from == null) {
            return true;
        }
        if (to instanceof EntityPlayer && !(from instanceof EntityPlayer)) {
            return true;
        }
        return to.func_110143_aJ() > from.func_110143_aJ();
    }

    public void setCapturedEntity(@Nullable EntityLivingBase capturedEntity) {
        this.captureCooldown = 15;
        if (MinecraftForge.EVENT_BUS.post((Event)new RifterReleaseEvent(this, this.capturedEntity))) {
            return;
        }
        if (this.capturedEntity != null) {
            this.resetCapturedEntity(this.capturedEntity);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new RifterCaptureEvent(this, capturedEntity))) {
            return;
        }
        this.capturedEntity = capturedEntity;
        this.dragSolver.setDragged(capturedEntity);
        if (capturedEntity != null) {
            this.initCapturedEntity(capturedEntity);
        }
        if (!this.field_70170_p.field_72995_K) {
            MessageCaptureEntity message = new MessageCaptureEntity(this, capturedEntity);
            Midnight.NETWORK.sendToAllTracking((IMessage)message, (Entity)this);
        }
    }

    private void initCapturedEntity(EntityLivingBase capturedEntity) {
        RifterCapturable capability = (RifterCapturable)capturedEntity.getCapability(Midnight.RIFTER_CAPTURABLE_CAP, null);
        if (capability != null) {
            capability.setCaptured(true);
        }
        capturedEntity.func_70690_d(new PotionEffect(ModEffects.STUNNED, 200, 1, false, false));
        capturedEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 400, 2, false, false));
    }

    private void resetCapturedEntity(EntityLivingBase capturedEntity) {
        RifterCapturable capability = (RifterCapturable)capturedEntity.getCapability(Midnight.RIFTER_CAPTURABLE_CAP, null);
        if (capability != null) {
            capability.setCaptured(false);
        }
    }

    public EntityLivingBase getCapturedEntity() {
        return this.capturedEntity;
    }

    public boolean hasCaptured() {
        return this.capturedEntity != null;
    }

    public EntityReference<EntityRift> getHomeRift() {
        return this.homeRift;
    }

    public DragSolver getDragSolver() {
        return this.dragSolver;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.RIFTER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.RIFTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.RIFTER_DEATH;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("home_rift", (NBTBase)this.homeRift.serialize(new NBTTagCompound()));
        compound.func_74757_a("spawned_through_rift", this.spawnedThroughRift);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.homeRift.deserialize(compound.func_74775_l("home_rift"));
        this.spawnedThroughRift = compound.func_74767_n("spawned_through_rift");
    }

    @Override
    public void onEnterRift(EntityRift rift) {
        if (this.capturedEntity != null) {
            this.setCapturedEntity(null);
        }
    }

    @Override
    public RiftTravelEntry createTravelEntry(EntityRift rift) {
        return this.createTravelEntry((Entity)this, rift);
    }

    @Override
    public Collection<RiftTravelEntry> getAdditionalTravelers(EntityRift rift) {
        if (this.capturedEntity != null) {
            return ImmutableList.of((Object)this.createTravelEntry((Entity)this.capturedEntity, rift));
        }
        return Collections.emptyList();
    }

    private RiftTravelEntry createTravelEntry(Entity entity, EntityRift rift) {
        return new RiftTravelEntry(entity);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.capturedEntity != null ? this.capturedEntity.func_145782_y() : -1);
    }

    public void readSpawnData(ByteBuf buffer) {
        Entity entity;
        int capturedId = buffer.readInt();
        if (capturedId != -1 && (entity = this.field_70170_p.func_73045_a(capturedId)) instanceof EntityLivingBase) {
            this.setCapturedEntity((EntityLivingBase)entity);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.LOOT_TABLE_RIFTER;
    }
}

