/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.common.entity.navigation.CustomPathNavigateGround;
import com.mushroom.midnight.common.entity.task.EntityTaskNeutral;
import com.mushroom.midnight.common.registry.ModLootTables;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntitySkulk
extends EntityAnimal {
    private static final DataParameter<Boolean> STEALTH = EntityDataManager.func_187226_a(EntitySkulk.class, (DataSerializer)DataSerializers.field_187198_h);
    private int stealthCooldown = 0;

    public EntitySkulk(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.6f);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STEALTH, (Object)Boolean.FALSE);
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected PathNavigate func_175447_b(World world) {
        return new CustomPathNavigateGround((EntityLiving)this, world);
    }

    public boolean func_70601_bi() {
        if (this.func_180425_c().func_177956_o() <= this.field_70170_p.func_181545_F()) {
            return false;
        }
        IBlockState belowState = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return belowState.func_185917_h() && belowState.func_189884_a((Entity)this);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setStealth(true);
        return livingdata;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityTaskNeutral((EntityCreature)this, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0), true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityTaskNeutral((EntityCreature)this, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false), false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.005f){

            public boolean func_75250_a() {
                boolean valid = super.func_75250_a();
                if (valid && EntitySkulk.this.canStealth()) {
                    EntitySkulk.this.setStealth(true);
                }
                return valid;
            }
        });
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this){

            public boolean func_75250_a() {
                boolean valid = super.func_75250_a();
                if (valid && EntitySkulk.this.canStealth()) {
                    EntitySkulk.this.setStealth(true);
                }
                return valid;
            }
        });
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityTaskNeutral((EntityCreature)this, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]), false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
    }

    public boolean func_70652_k(Entity entity) {
        super.func_70652_k(entity);
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        this.setStealth(false);
        return flag;
    }

    public void func_184609_a(EnumHand hand) {
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.stealthCooldown > 0) {
            --this.stealthCooldown;
        }
    }

    public boolean isStealth() {
        return (Boolean)this.field_70180_af.func_187225_a(STEALTH);
    }

    public boolean canStealth() {
        return this.stealthCooldown <= 0;
    }

    public void setStealth(boolean flag) {
        this.field_70180_af.func_187227_b(STEALTH, (Object)flag);
        this.stealthCooldown = 60;
    }

    public float func_70689_ay() {
        return super.func_70689_ay() * (this.isStealth() ? 0.3f : 1.0f);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        this.setStealth(false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("stealth", this.isStealth());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("stealth", 1)) {
            this.setStealth(compound.func_74767_n("stealth"));
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public int func_70627_aG() {
        return 100;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.LOOT_TABLE_SKULK;
    }
}

