/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.AnimationCapability;
import com.mushroom.midnight.common.registry.ModBlocks;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityTaskEatGrass
extends EntityAIBase {
    private final Predicate<IBlockState> eatPredicate;
    protected final EntityLiving owner;
    protected AnimationCapability capAnim;
    protected final int duration;

    public EntityTaskEatGrass(EntityLiving owner, int duration, boolean vanillaBehavior, Predicate<IBlockState> eatPredicate) {
        this.owner = owner;
        this.eatPredicate = vanillaBehavior ? eatPredicate.or(p -> p.func_177230_c() == Blocks.field_150329_H && p.func_177229_b((IProperty)BlockTallGrass.field_176497_a) == BlockTallGrass.EnumType.GRASS) : eatPredicate;
        this.duration = duration;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        this.capAnim = (AnimationCapability)this.owner.getCapability(Midnight.ANIMATION_CAP, null);
        if (this.capAnim == null || this.owner.func_70681_au().nextInt(this.owner.func_70631_g_() ? 50 : 500) != 0) {
            return false;
        }
        BlockPos currentPos = this.owner.func_180425_c();
        if (this.eatPredicate.test(this.owner.field_70170_p.func_180495_p(currentPos))) {
            return true;
        }
        Block belowBlock = this.owner.field_70170_p.func_180495_p(currentPos.func_177977_b()).func_177230_c();
        return belowBlock == Blocks.field_150349_c || belowBlock == ModBlocks.MIDNIGHT_GRASS;
    }

    public void func_75249_e() {
        this.capAnim.setAnimation((Entity)this.owner, AnimationCapability.AnimationType.EAT, this.duration);
        this.owner.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.capAnim.resetAnimation((Entity)this.owner);
    }

    public boolean func_75253_b() {
        return this.capAnim.getProgress(1.0f) < 1.0f;
    }

    public void func_75246_d() {
        if (this.capAnim.getCurrentTick() == this.capAnim.getDuration() - 10) {
            BlockPos currentPos = this.owner.func_180425_c();
            IBlockState currentState = this.owner.field_70170_p.func_180495_p(currentPos);
            if (this.eatPredicate.test(currentState)) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.owner.field_70170_p, (Entity)this.owner)) {
                    this.eatPlant(currentState, currentPos);
                }
                this.owner.func_70615_aA();
            } else {
                BlockPos belowPos = currentPos.func_177977_b();
                Block belowBlock = this.owner.field_70170_p.func_180495_p(belowPos).func_177230_c();
                if (belowBlock == Blocks.field_150349_c || belowBlock == ModBlocks.MIDNIGHT_GRASS) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.owner.field_70170_p, (Entity)this.owner)) {
                        this.owner.field_70170_p.func_175718_b(2001, belowPos, Block.func_149682_b((Block)belowBlock));
                        this.owner.field_70170_p.func_180501_a(belowPos, (belowBlock == Blocks.field_150349_c ? Blocks.field_150346_d : ModBlocks.MIDNIGHT_DIRT).func_176223_P(), 2);
                    }
                    this.owner.func_70615_aA();
                }
            }
        }
    }

    protected void eatPlant(IBlockState state, BlockPos pos) {
        this.owner.field_70170_p.func_175655_b(pos, false);
    }
}

