/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.entity.creature.EntityRifter;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.util.WorldUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class EntityTaskRifterReturn
extends EntityAIBase {
    protected static final int RETURN_EARLY_TIME = 80;
    protected static final int INVALIDATE_TIME = 20;
    protected final EntityRifter owner;
    protected final double returnSpeed;
    protected int invalidCount = 0;
    protected Path path;

    public EntityTaskRifterReturn(EntityRifter owner, double returnSpeed) {
        this.owner = owner;
        this.returnSpeed = returnSpeed;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.shouldReturn();
    }

    public boolean func_75253_b() {
        return this.shouldReturn() && this.invalidCount <= 20;
    }

    public boolean shouldReturn() {
        if (Helper.isMidnightDimension(this.owner.field_70170_p)) {
            return false;
        }
        Optional<EntityRift> homeRift = this.owner.getHomeRift().deref(false);
        return homeRift.isPresent() && homeRift.get().getBridge().getTimeUntilClose() < 80;
    }

    public void func_75249_e() {
        this.path = this.computeFollowPath();
        this.owner.func_70661_as().func_75484_a(this.path, this.returnSpeed);
    }

    public void func_75246_d() {
        int n;
        Path targetPath = this.computeFollowPath();
        if (targetPath == null) {
            this.path = null;
            return;
        }
        Path currentPath = this.owner.func_70661_as().func_75505_d();
        if (currentPath != targetPath) {
            this.owner.func_70661_as().func_75484_a(targetPath, this.returnSpeed);
        }
        if (this.path == null) {
            int n2 = this.invalidCount;
            n = n2;
            this.invalidCount = n2 + 1;
        } else {
            n = 0;
        }
        this.invalidCount = n;
    }

    @Nullable
    private Path computeFollowPath() {
        if (this.isPathComplete(this.path)) {
            this.path = null;
            this.invalidCount = 0;
        }
        if (this.path == null) {
            this.owner.func_70661_as().func_75499_g();
            Optional<EntityRift> derefRift = this.owner.getHomeRift().deref(true);
            if (!derefRift.isPresent()) {
                return null;
            }
            EntityRift homeRift = derefRift.get();
            BlockPos surface = WorldUtil.findSurfaceOrInput(homeRift.field_70170_p, homeRift.func_180425_c(), 16);
            this.path = this.owner.func_70661_as().func_179680_a(surface);
            if (this.path == null) {
                this.path = this.computePathTowards(surface);
            }
        }
        return this.path;
    }

    @Nullable
    private Path computePathTowards(BlockPos surface) {
        Vec3d target = new Vec3d((Vec3i)surface);
        for (int i = 0; i < 16; ++i) {
            Path path;
            Vec3d pathPos = RandomPositionGenerator.func_75464_a((EntityCreature)this.owner, (int)24, (int)4, (Vec3d)target);
            if (pathPos == null || (path = this.owner.func_70661_as().func_75488_a(pathPos.field_72450_a, pathPos.field_72448_b, pathPos.field_72449_c)) == null) continue;
            return path;
        }
        return null;
    }

    private boolean isPathComplete(Path path) {
        if (path == null || path.func_75879_b()) {
            return true;
        }
        PathPoint finalPoint = path.func_75870_c();
        return finalPoint == null || this.owner.func_70092_e(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c) < 2.25;
    }

    public void func_75251_c() {
        this.owner.func_70661_as().func_75499_g();
        this.path = null;
        this.invalidCount = 0;
    }
}

