/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.item;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.client.particle.MidnightParticles;
import com.mushroom.midnight.common.entity.EntityCloud;
import com.mushroom.midnight.common.entity.projectile.EntitySporeBomb;
import com.mushroom.midnight.common.network.MessageBombExplosion;
import com.mushroom.midnight.common.registry.ModEffects;
import com.mushroom.midnight.common.registry.ModItems;
import com.mushroom.midnight.common.registry.ModTabs;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.stream.IntStream;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemSporeBomb
extends Item
implements IModelProvider {
    public static int MAX_FUSE_TIME = 200;

    public ItemSporeBomb() {
        this.func_77637_a(ModTabs.MIDNIGHT_ITEMS);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserBehavior());
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (BombType bomb : BombType.values()) {
                items.add((Object)new ItemStack((Item)this, 1, bomb.ordinal()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + BombType.fromId(stack.func_77960_j()).name().toLowerCase();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == this) {
            player.func_184811_cZ().func_185145_a((Item)this, 10);
            if (!world.field_72995_K) {
                EntitySporeBomb bomb = ItemSporeBomb.createEntityBomb(world, heldItem, player);
                bomb.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_72838_d((Entity)bomb);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187511_aA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        this.updateBomb(world, stack, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        boolean valid = this.updateBomb(entityItem.field_70170_p, entityItem.func_92059_d(), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v);
        if (valid) {
            entityItem.func_70106_y();
        }
        return valid;
    }

    private boolean updateBomb(World world, ItemStack stack, double x, double y, double z) {
        if (!world.field_72995_K) {
            long fuseTime = ItemSporeBomb.getFuseTime(world, stack);
            if (fuseTime <= 0L) {
                ItemSporeBomb.explode(BombType.fromId(stack.func_77960_j()), world, x, y, z);
                stack.func_190918_g(1);
                return true;
            }
            if (fuseTime < (long)MAX_FUSE_TIME) {
                world.func_184148_a(null, x, y, z, SoundEvents.field_187659_cY, SoundCategory.HOSTILE, world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat());
            }
        }
        return false;
    }

    public static void setFuseTime(World world, ItemStack stack, int time) {
        if (stack.func_77973_b() == ModItems.SPORE_BOMB) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
                stack.func_77982_d(compound);
            }
            compound.func_74772_a("fuse_time", world.func_82737_E() + (long)time);
        }
    }

    public static long getFuseTime(World world, ItemStack stack) {
        return stack.func_77973_b() == ModItems.SPORE_BOMB && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("fuse_time", 4) ? Math.max(0L, stack.func_77978_p().func_74763_f("fuse_time") - world.func_82737_E()) : (long)MAX_FUSE_TIME;
    }

    public static boolean checkExplode(World world, ItemStack stack) {
        return ItemSporeBomb.getFuseTime(world, stack) <= 0L;
    }

    @Override
    public void gatherVariants(Int2ObjectMap<String> variants) {
        IntStream.range(0, BombType.values().length).forEach(i -> {
            String cfr_ignored_0 = (String)variants.put(i, (Object)"inventory");
        });
    }

    public static void explode(BombType bombType, World world, double x, double y, double z) {
        float explosionRadius = 1.0f;
        Midnight.NETWORK.sendToAllTracking((IMessage)new MessageBombExplosion(x, y, z, bombType.getColor()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 50.0));
        world.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 1.0f, 1.0f);
        switch (bombType) {
            case NIGHTSHROOM: {
                world.func_72838_d((Entity)ItemSporeBomb.createLingeringCloud(bombType, world, x, y, z).setParticle(MidnightParticles.FADING_SPORE).setParticleParam(bombType.getColor()).addEffect(new PotionEffect(ModEffects.DARKNESS, 100, 0, false, true)));
                break;
            }
            case DEWSHROOM: {
                world.func_72838_d((Entity)ItemSporeBomb.createLingeringCloud(bombType, world, x, y, z).setParticle(MidnightParticles.FADING_SPORE).setParticleParam(bombType.getColor()).setRadiusPerTick(0.0025f).addEffect(new PotionEffect(ModEffects.STUNNED, 100, 0, false, true)).addEffect(new PotionEffect(MobEffects.field_76421_d, 100, 5, false, true)));
                break;
            }
            case VIRIDSHROOM: {
                world.func_72838_d((Entity)ItemSporeBomb.createLingeringCloud(bombType, world, x, y, z).setAllowTeleport().setParticle(MidnightParticles.FADING_SPORE).setParticleParam(bombType.getColor()).addEffect(new PotionEffect(ModEffects.TORMENTED, 100, 0, false, true)));
                break;
            }
            case BOGSHROOM: {
                world.func_72838_d((Entity)ItemSporeBomb.createLingeringCloud(bombType, world, x, y, z).setParticle(MidnightParticles.FADING_SPORE).setParticleParam(bombType.getColor()).addEffect(new PotionEffect(ModEffects.CONFUSION, 200, 0, false, true)));
            }
        }
    }

    private static EntityCloud createLingeringCloud(BombType bombType, World world, double x, double y, double z) {
        float radius = 2.5f;
        int duration = 300;
        return new EntityCloud(world, x, y, z).setRadius(radius).setWaitTime(10).setDuration(duration).setRadiusPerTick(-radius / (float)duration).setPotion(PotionTypes.field_185229_a).setColor(bombType.getColor());
    }

    private static EntitySporeBomb createEntityBomb(World world, ItemStack stack, EntityPlayer player) {
        EntitySporeBomb bomb = new EntitySporeBomb(world, (EntityLivingBase)player);
        return ItemSporeBomb.addStackToBomb(bomb, stack);
    }

    private static EntitySporeBomb createEntityBomb(World world, ItemStack stack, IPosition pos) {
        EntitySporeBomb bomb = new EntitySporeBomb(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        return ItemSporeBomb.addStackToBomb(bomb, stack);
    }

    private static EntitySporeBomb addStackToBomb(EntitySporeBomb bomb, ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        ItemStack newStack = stack.func_77946_l();
        if (compound == null || !compound.func_150297_b("fuse_time", 4)) {
            ItemSporeBomb.setFuseTime(bomb.field_70170_p, newStack, MAX_FUSE_TIME);
        }
        bomb.setBombStack(newStack);
        return bomb;
    }

    private static class DispenserBehavior
    extends BehaviorProjectileDispense {
        private DispenserBehavior() {
        }

        protected IProjectile func_82499_a(World world, IPosition pos, ItemStack stack) {
            return ItemSporeBomb.createEntityBomb(world, stack, pos);
        }
    }

    public static enum BombType {
        NIGHTSHROOM(7290838),
        DEWSHROOM(6937061),
        VIRIDSHROOM(4183623),
        BOGSHROOM(15103021);

        private final int color;

        private BombType(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        public static BombType getDefault() {
            return NIGHTSHROOM;
        }

        public static BombType fromId(int id) {
            return BombType.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(BombType.values().length - 1))];
        }

        public static BombType fromStack(ItemStack stack) {
            return BombType.fromId(stack.func_77960_j());
        }
    }
}

