/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.network;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.entity.creature.EntityRifter;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageCaptureEntity
implements IMessage {
    private int rifterId;
    private int capturedId;

    public MessageCaptureEntity() {
    }

    public MessageCaptureEntity(EntityRifter rifter, EntityLivingBase captured) {
        this.rifterId = rifter.func_145782_y();
        this.capturedId = captured != null ? captured.func_145782_y() : -1;
    }

    public void fromBytes(ByteBuf buf) {
        this.rifterId = buf.readInt();
        this.capturedId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.rifterId);
        buf.writeInt(this.capturedId);
    }

    public static class Handler
    implements IMessageHandler<MessageCaptureEntity, IMessage> {
        public IMessage onMessage(MessageCaptureEntity message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Midnight.proxy.handleMessage(ctx, player -> {
                    EntityRifter rifterEntity = Handler.getEntity(player.field_70170_p, message.rifterId, EntityRifter.class);
                    EntityLivingBase capturedEntity = Handler.getEntity(player.field_70170_p, message.capturedId, EntityLivingBase.class);
                    if (rifterEntity != null) {
                        rifterEntity.setCapturedEntity(capturedEntity);
                    }
                });
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private static <T> T getEntity(World world, int id, Class<T> type) {
            Entity entity = world.func_73045_a(id);
            if (entity != null && type.isAssignableFrom(entity.getClass())) {
                return type.cast(entity);
            }
            return null;
        }
    }
}

