/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

import com.mushroom.midnight.common.entity.EntityRift;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class CompassRotationGetter
implements IItemPropertyGetter {
    private static final double RIFT_INFLUENCE_RANGE = 64.0;
    private static final long RIFT_CHECK_INTERVAL = 100L;
    private double rotation;
    private double rotVelocity;
    private long lastUpdateTick;
    private EntityRift closestRift;
    private long lastRiftCheck;

    public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase livingHolder) {
        EntityLivingBase entity;
        boolean heldByLiving = livingHolder != null;
        Object object = entity = livingHolder != null ? livingHolder : stack.func_82836_z();
        if (entity == null) {
            return 0.0f;
        }
        if (world == null) {
            world = entity.field_70170_p;
        }
        double angle = this.computeTargetAngle(world, (Entity)entity);
        if (heldByLiving) {
            angle = this.applyWobble(world, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    private double applyWobble(World world, double targetAngle) {
        if (world.func_82737_E() != this.lastUpdateTick) {
            this.lastUpdateTick = world.func_82737_E();
            double deltaAngle = targetAngle - this.rotation;
            deltaAngle = MathHelper.func_191273_b((double)(deltaAngle + 0.5), (double)1.0) - 0.5;
            this.rotVelocity += deltaAngle * 0.1;
            this.rotVelocity *= 0.8;
            this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rotVelocity), (double)1.0);
        }
        return this.rotation;
    }

    private double computeTargetAngle(World world, Entity entity) {
        double angle = world.field_73011_w.func_76569_d() ? this.computeAngle(entity, world.func_175694_M()) : Math.random();
        EntityRift closestRift = this.getClosestRift(entity);
        if (closestRift == null) {
            return angle;
        }
        double influence = 1.0 - Math.pow((double)closestRift.func_70032_d(entity) / 64.0, 3.0);
        double riftAngle = this.computeAngle(entity, closestRift.func_180425_c());
        return angle + (riftAngle - angle) * influence;
    }

    @Nullable
    private EntityRift getClosestRift(Entity entity) {
        World world = entity.field_70170_p;
        long time = world.func_82737_E();
        if (time - this.lastRiftCheck > 100L) {
            AxisAlignedBB bounds = new AxisAlignedBB(entity.func_180425_c()).func_186662_g(64.0);
            List rifts = world.func_72872_a(EntityRift.class, bounds);
            this.closestRift = this.findClosestRift(entity, rifts);
            this.lastRiftCheck = time;
        }
        return this.closestRift;
    }

    @Nullable
    private EntityRift findClosestRift(Entity entity, Collection<EntityRift> rifts) {
        EntityRift closestRift = null;
        double closestRiftDistanceSq = Double.MAX_VALUE;
        for (EntityRift rift : rifts) {
            double distanceSq = rift.func_70068_e(entity);
            if (!(distanceSq < closestRiftDistanceSq)) continue;
            closestRiftDistanceSq = distanceSq;
            closestRift = rift;
        }
        return closestRift;
    }

    private double computeAngle(Entity entity, BlockPos pos) {
        double sourceAngle = this.computeSourceAngle(entity);
        double targetAngle = Math.atan2((double)pos.func_177952_p() - entity.field_70161_v, (double)pos.func_177958_n() - entity.field_70165_t) / (Math.PI * 2);
        return 0.5 - (sourceAngle - 0.25 - targetAngle);
    }

    private double computeSourceAngle(Entity entity) {
        double sourceAngle = entity.field_70177_z;
        if (entity instanceof EntityItemFrame) {
            sourceAngle = this.getFrameRotation((EntityItemFrame)entity);
        }
        return MathHelper.func_191273_b((double)(sourceAngle / 360.0), (double)1.0);
    }

    private double getFrameRotation(EntityItemFrame itemFrame) {
        return MathHelper.func_188209_b((int)(180 + itemFrame.field_174860_b.func_176736_b() * 90));
    }
}

