/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

@FunctionalInterface
public interface Curve {
    public static Curve nearest() {
        return x -> x < 0.5 ? 0.0 : 1.0;
    }

    public static Curve linear() {
        return x -> x;
    }

    public static Curve sine() {
        return x -> (Math.cos(Math.PI * x) - 1.0) / -2.0;
    }

    public double get(double var1);

    default public double interpolate(double a, double b, double x) {
        double t = this.get(x);
        return (1.0 - t) * a + t * b;
    }
}

