/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import java.util.Arrays;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;

public class CreatureTypeCount {
    private final int[] counts;

    private CreatureTypeCount(int[] counts) {
        this.counts = counts;
    }

    public int getCount(EnumCreatureType creatureType) {
        int ordinal = creatureType.ordinal();
        if (ordinal >= this.counts.length) {
            return 0;
        }
        return this.counts[ordinal];
    }

    public static CreatureTypeCount count(World world) {
        return CreatureTypeCount.count(world, Arrays.asList(EnumCreatureType.values()));
    }

    public static CreatureTypeCount count(World world, Collection<EnumCreatureType> creatureTypes) {
        int[] counts = new int[EnumCreatureType.values().length];
        for (Entity entity : world.field_72996_f) {
            for (EnumCreatureType creatureType : creatureTypes) {
                if (!entity.isCreatureType(creatureType, true)) continue;
                int n = creatureType.ordinal();
                counts[n] = counts[n] + 1;
            }
        }
        return new CreatureTypeCount(counts);
    }
}

