/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.EntitySpawnConfigured;
import com.mushroom.midnight.common.biome.config.SpawnerConfig;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.util.WeightedPool;
import com.mushroom.midnight.common.world.CreatureTypeCount;
import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class MidnightEntitySpawner<T extends EntitySpawnConfigured> {
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    private static final int CHUNK_RANGE = 8;
    private static final long ANIMAL_SPAWN_INTERVAL = 400L;
    private final Function<BlockPos, T> biomeFunction;
    private final SurfacePlacementLevel placementLevel;
    private final Set<ChunkPos> eligibleSpawnChunks = new HashSet<ChunkPos>();

    public MidnightEntitySpawner(Function<BlockPos, T> biomeFunction, SurfacePlacementLevel placementLevel) {
        this.biomeFunction = biomeFunction;
        this.placementLevel = placementLevel;
    }

    public void spawnAroundPlayers(WorldServer world) {
        Set<ChunkPos> spawnChunks = this.computeEligibleSpawnChunks(world);
        Collection validCreatureTypes = Arrays.stream(EnumCreatureType.values()).filter(c -> this.shouldSpawnCreatureType((World)world, (EnumCreatureType)c)).collect(Collectors.toList());
        if (validCreatureTypes.isEmpty()) {
            return;
        }
        CreatureTypeCount entityCount = CreatureTypeCount.count((World)world, validCreatureTypes);
        for (EnumCreatureType creatureType : validCreatureTypes) {
            int maxCreatureCount;
            int actualCreatureCount = entityCount.getCount(creatureType);
            if (actualCreatureCount > (maxCreatureCount = creatureType.func_75601_b() * spawnChunks.size() / MOB_COUNT_DIV)) continue;
            this.spawnCreaturesOfType(world, spawnChunks, creatureType);
        }
    }

    public void populateChunk(World world, int chunkX, int chunkZ, Random random) {
        int globalX = chunkX << 4;
        int globalZ = chunkZ << 4;
        int originX = globalX + 8;
        int originZ = globalZ + 8;
        BlockPos centerPos = new BlockPos(globalX + 16, 0, globalZ + 16);
        EntitySpawnConfigured biome = (EntitySpawnConfigured)this.biomeFunction.apply(centerPos);
        SpawnerConfig spawnerConfig = biome.getSpawnerConfig();
        if (spawnerConfig.isEmpty()) {
            return;
        }
        while (random.nextFloat() < spawnerConfig.getSpawnChance()) {
            WeightedPool<Biome.SpawnListEntry> pool = spawnerConfig.getPool(EnumCreatureType.CREATURE);
            Biome.SpawnListEntry entry = pool.pick(world.field_73012_v);
            if (entry == null) continue;
            this.spawnGroupInChunk(world, originX, originZ, random, entry);
        }
    }

    private void spawnCreaturesOfType(WorldServer world, Set<ChunkPos> spawnChunks, EnumCreatureType creatureType) {
        ArrayList<ChunkPos> shuffledChunks = new ArrayList<ChunkPos>(spawnChunks);
        Collections.shuffle(shuffledChunks);
        for (ChunkPos chunkPos : shuffledChunks) {
            BlockPos pos = this.getRandomPositionInChunk((World)world, chunkPos.field_77276_a, chunkPos.field_77275_b);
            IBlockState state = world.func_180495_p(pos);
            if (state.func_185915_l()) continue;
            this.spawnEntitiesAround(world, pos, creatureType);
            if (creatureType != Midnight.MIDNIGHT_MOB) continue;
            break;
        }
    }

    private void spawnEntitiesAround(WorldServer world, BlockPos pos, EnumCreatureType creatureType) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int spawnedEntities = 0;
        block0: for (int i = 0; i < 3; ++i) {
            int range = 6;
            Biome.SpawnListEntry selectedEntry = null;
            IEntityLivingData livingData = null;
            mutablePos.func_189533_g((Vec3i)pos);
            int spawnGroupSize = MathHelper.func_76143_f((double)(Math.random() * 4.0));
            for (int groupIndex = 0; groupIndex < spawnGroupSize; ++groupIndex) {
                float spawnZ;
                float spawnY;
                float spawnX;
                EntityLiving creature;
                Event.Result spawnResult;
                EntitySpawnConfigured biome;
                WeightedPool<Biome.SpawnListEntry> pool;
                mutablePos.func_181079_c(mutablePos.func_177958_n() + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range), mutablePos.func_177956_o() + world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), mutablePos.func_177952_p() + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range));
                if (world.func_175636_b((double)mutablePos.func_177958_n() + 0.5, (double)mutablePos.func_177956_o(), (double)mutablePos.func_177952_p() + 0.5, 24.0)) continue;
                if (selectedEntry == null && (selectedEntry = (pool = (biome = (EntitySpawnConfigured)this.biomeFunction.apply(pos)).getSpawnerConfig().getPool(creatureType)).pick(world.field_73012_v)) == null) continue block0;
                if (!this.canSpawnAt(world, creatureType, (BlockPos)mutablePos, selectedEntry) || (spawnResult = ForgeEventFactory.canEntitySpawn((EntityLiving)(creature = this.createEntity((World)world, (BlockPos)mutablePos, selectedEntry)), (World)world, (float)(spawnX = (float)mutablePos.func_177958_n() + 0.5f), (float)(spawnY = (float)mutablePos.func_177956_o()), (float)(spawnZ = (float)mutablePos.func_177952_p() + 0.5f), null)) != Event.Result.ALLOW && spawnResult != Event.Result.DEFAULT || !creature.func_70601_bi() || !creature.func_70058_J()) continue;
                if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)creature, (World)world, (float)spawnX, (float)spawnY, (float)spawnZ, null)) {
                    livingData = creature.func_180482_a(world.func_175649_E(new BlockPos((Entity)creature)), livingData);
                }
                if (creature.func_70058_J()) {
                    ++spawnedEntities;
                    world.func_72838_d((Entity)creature);
                } else {
                    creature.func_70106_y();
                }
                if (spawnedEntities < ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)creature)) continue;
                return;
            }
        }
    }

    private void spawnGroupInChunk(World world, int originX, int originZ, Random random, Biome.SpawnListEntry spawnEntry) {
        int groupSize = spawnEntry.field_76301_c + random.nextInt(spawnEntry.field_76299_d - spawnEntry.field_76301_c + 1);
        int centerX = originX + random.nextInt(16);
        int centerZ = originZ + random.nextInt(16);
        int x = centerX;
        int z = centerZ;
        IEntityLivingData livingData = null;
        block0: for (int i = 0; i < groupSize; ++i) {
            for (int attempt = 0; attempt < 4; ++attempt) {
                boolean spawnedEntity = false;
                BlockPos pos = this.placementLevel.getSurfacePos(world, new BlockPos(x, 0, z));
                if (this.isSpawnPositionValid(EntityLiving.SpawnPlacementType.ON_GROUND, world, pos)) {
                    EntityLiving creature = this.createEntity(world, pos, spawnEntry);
                    if (ForgeEventFactory.canEntitySpawn((EntityLiving)creature, (World)world, (float)((float)x + 0.5f), (float)pos.func_177956_o(), (float)((float)z + 0.5f), null) == Event.Result.DENY) {
                        creature.func_70106_y();
                        continue;
                    }
                    world.func_72838_d((Entity)creature);
                    livingData = creature.func_180482_a(world.func_175649_E(new BlockPos((Entity)creature)), livingData);
                    spawnedEntity = true;
                }
                x += random.nextInt(5) - random.nextInt(5);
                z += random.nextInt(5) - random.nextInt(5);
                while (x < originX || x >= originX + 16 || z < originZ || z >= originZ + 16) {
                    x = centerX + random.nextInt(5) - random.nextInt(5);
                    z = centerZ + random.nextInt(5) - random.nextInt(5);
                }
                if (spawnedEntity) continue block0;
            }
        }
    }

    private EntityLiving createEntity(World world, BlockPos pos, Biome.SpawnListEntry selectedEntry) {
        try {
            EntityLiving creature = selectedEntry.newInstance(world);
            float yaw = world.field_73012_v.nextFloat() * 360.0f;
            creature.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, yaw, 0.0f);
            return creature;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to spawn entry " + selectedEntry, e);
        }
    }

    private boolean canSpawnAt(WorldServer world, EnumCreatureType creatureType, BlockPos pos, Biome.SpawnListEntry selectedEntry) {
        EntityLiving.SpawnPlacementType placementType = EntitySpawnPlacementRegistry.func_180109_a((Class)selectedEntry.field_76300_b);
        return this.isSpawnPositionValid(placementType, (World)world, pos);
    }

    private Set<ChunkPos> computeEligibleSpawnChunks(WorldServer world) {
        this.eligibleSpawnChunks.clear();
        Stream<EntityPlayer> playerStream = this.getPlayerStream((World)world);
        playerStream.forEach(player -> {
            int playerChunkX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
            int playerChunkZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
            for (int z = -8; z <= 8; ++z) {
                for (int x = -8; x <= 8; ++x) {
                    PlayerChunkMapEntry trackedChunk;
                    boolean isLimit = x == -8 || x == 8 || z == -8 || z == 8;
                    ChunkPos chunkPos = new ChunkPos(playerChunkX + x, playerChunkZ + z);
                    if (isLimit || !world.func_175723_af().func_177730_a(chunkPos) || (trackedChunk = world.func_184164_w().func_187301_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) == null || !trackedChunk.func_187274_e()) continue;
                    this.eligibleSpawnChunks.add(chunkPos);
                }
            }
        });
        return this.eligibleSpawnChunks;
    }

    private Stream<EntityPlayer> getPlayerStream(World world) {
        return world.field_73010_i.stream().filter(player -> !player.func_175149_v());
    }

    private boolean shouldSpawnCreatureType(World world, EnumCreatureType creatureType) {
        if (!creatureType.func_75599_d() && world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (creatureType == Midnight.MIDNIGHT_MOB) {
            return world.func_82737_E() % (long)MidnightConfig.general.monsterSpawnRate == 0L;
        }
        return !creatureType.func_82705_e() || world.func_82737_E() % 400L == 0L;
    }

    private BlockPos getRandomPositionInChunk(World world, int chunkX, int chunkZ) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int x = (chunkX << 4) + world.field_73012_v.nextInt(16);
        int z = (chunkZ << 4) + world.field_73012_v.nextInt(16);
        int surfaceY = MathHelper.func_154354_b((int)(this.placementLevel.getSurfacePos(world, new BlockPos(x, 0, z)).func_177956_o() + 1), (int)16);
        int y = world.field_73012_v.nextInt(surfaceY > 0 ? surfaceY : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(x, y, z);
    }

    private boolean isSpawnPositionValid(EntityLiving.SpawnPlacementType placementType, World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && placementType.canSpawnAt(world, pos);
    }
}

