/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.common.biome.MidnightBiomeLayer;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.registry.ModDimensions;
import com.mushroom.midnight.common.world.MidnightBiomeProvider;
import com.mushroom.midnight.common.world.MidnightChunkGenerator;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MidnightWorldProvider
extends WorldProvider {
    private static final Vec3d FOG_COLOR = new Vec3d(0.085, 0.04, 0.1225);
    private static final Vec3d LIGHTING_FOG_COLOR = new Vec3d(1.0, 0.35, 0.25);

    protected void func_76572_b() {
        this.field_191067_f = false;
        this.field_76578_c = new MidnightBiomeProvider(this.field_76579_a, MidnightBiomeLayer.SURFACE);
        this.field_76576_e = false;
    }

    public int getActualHeight() {
        return 255;
    }

    public IChunkGenerator func_186060_c() {
        return new MidnightChunkGenerator(this.field_76579_a);
    }

    public DimensionType func_186058_p() {
        return ModDimensions.MIDNIGHT;
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.BED_EXPLODES;
    }

    public boolean func_76569_d() {
        return false;
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return true;
    }

    protected void func_76556_a() {
        float baseLight = 0.06f;
        for (int i = 0; i <= 15; ++i) {
            float alpha = 1.0f - (float)i / 15.0f;
            float brightness = (1.0f - alpha) / (alpha * 10.0f + 1.0f);
            this.field_76573_f[i] = (float)(Math.pow(brightness, 2.5) * 3.0) + baseLight;
        }
    }

    public void getLightmapColors(float partialTicks, float sunBrightness, float skyLight, float blockLight, float[] colors) {
        colors[0] = blockLight * 0.93f + 0.07f;
        colors[1] = blockLight * 0.96f + 0.03f;
        colors[2] = blockLight * 0.94f + 0.16f;
        if (this.field_76579_a.func_175658_ac() > 0) {
            colors[0] = 0.95f;
            colors[1] = 0.3f;
            colors[2] = 0.3f;
        }
    }

    public boolean isDaytime() {
        return false;
    }

    public float getSunBrightnessFactor(float partialTicks) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        if (this.field_76579_a.func_175658_ac() > 0 && Minecraft.func_71410_x().field_71439_g.field_70163_u > 50.0) {
            return LIGHTING_FOG_COLOR;
        }
        return FOG_COLOR;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.5f;
    }

    public void calculateInitialWeather() {
    }

    public void updateWeather() {
        this.setAllowedSpawnTypes(false, false);
        if (this.field_76579_a instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)this.field_76579_a;
            PlayerChunkMap chunkMap = worldServer.func_184164_w();
            Random rand = this.field_76579_a.field_73012_v;
            Iterator iterator = this.field_76579_a.getPersistentChunkIterable(chunkMap.func_187300_b());
            iterator.forEachRemaining(chunk -> {
                int globalX = chunk.field_76635_g << 4;
                int globalZ = chunk.field_76647_h << 4;
                if (rand.nextInt(200000) == 0) {
                    int lightningX = globalX + rand.nextInt(16);
                    int lightningZ = globalZ + rand.nextInt(16);
                    BlockPos pos = this.field_76579_a.func_175725_q(new BlockPos(lightningX, 0, lightningZ));
                    EntityLightningBolt lightning = new EntityLightningBolt(this.field_76579_a, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), !MidnightConfig.general.allowLightningDamage);
                    this.field_76579_a.func_72942_c((Entity)lightning);
                }
            });
        }
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean func_76567_e() {
        return MidnightConfig.general.canRespawnInMidnight;
    }

    public boolean shouldClientCheckLighting() {
        return true;
    }
}

