/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.util.WorldUtil;
import com.mushroom.midnight.common.world.feature.MidnightNaturalFeature;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DeadLogFeature
extends MidnightNaturalFeature {
    private final IBlockState log;

    public DeadLogFeature(IBlockState log) {
        this.log = log;
    }

    public DeadLogFeature() {
        this(ModBlocks.DEAD_WOOD_LOG.func_176223_P());
    }

    @Override
    public boolean placeFeature(World world, Random rand, BlockPos origin) {
        BlockPos endPos;
        EnumFacing direction = EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length)];
        BlockLog.EnumAxis axis = direction.func_176740_k() == EnumFacing.Axis.X ? BlockLog.EnumAxis.X : BlockLog.EnumAxis.Z;
        BlockLog.EnumAxis perpendicular = axis == BlockLog.EnumAxis.X ? BlockLog.EnumAxis.Z : BlockLog.EnumAxis.X;
        int length = rand.nextInt(4) + 3;
        int halfLength = length / 2;
        BlockPos basePos = origin.func_177967_a(direction, -halfLength);
        if (!this.checkValid(world, basePos, endPos = origin.func_177967_a(direction, length - halfLength))) {
            return false;
        }
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)basePos, (BlockPos)endPos)) {
            this.placeState(world, pos, this.log.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
        }
        int extrusionCount = rand.nextInt(3);
        for (int i = 0; i < extrusionCount; ++i) {
            BlockPos intermediate = basePos.func_177967_a(direction, rand.nextInt(length));
            EnumFacing side = rand.nextBoolean() ? direction.func_176746_e() : direction.func_176735_f();
            this.placeState(world, intermediate.func_177972_a(side), this.log.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)perpendicular));
        }
        return true;
    }

    private boolean checkValid(World world, BlockPos basePos, BlockPos endPos) {
        BlockPos minPos = WorldUtil.min(basePos, endPos).func_177982_a(-1, 0, -1);
        BlockPos maxPos = WorldUtil.max(basePos, endPos).func_177982_a(1, 1, 1);
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)minPos, (BlockPos)maxPos)) {
            if (this.canReplace(world, pos)) continue;
            return false;
        }
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)basePos, (BlockPos)endPos)) {
            pos.func_189536_c(EnumFacing.DOWN);
            IBlockState groundState = world.func_180495_p(pos);
            if (!groundState.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
                return false;
            }
            pos.func_189536_c(EnumFacing.UP);
        }
        return true;
    }
}

