/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.block.BlockMidnightFungiHat;
import com.mushroom.midnight.common.block.BlockMidnightFungiShelf;
import com.mushroom.midnight.common.block.BlockMidnightFungiStem;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.util.WorldUtil;
import com.mushroom.midnight.common.world.feature.MidnightNaturalFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class LargeFungiFeature
extends MidnightNaturalFeature {
    private static final Block[] SHELF_BLOCKS = new Block[]{ModBlocks.NIGHTSHROOM_SHELF, ModBlocks.DEWSHROOM_SHELF, ModBlocks.VIRIDSHROOM_SHELF};
    private static final int SHELF_ATTACH_CHANCE = 6;
    private final IBlockState stem;
    private final IBlockState hat;

    public LargeFungiFeature(IBlockState stem, IBlockState hat) {
        this.stem = stem;
        this.hat = hat;
    }

    @Override
    public boolean placeFeature(World world, Random rand, BlockPos origin) {
        if (!this.canGrow(world, origin.func_177977_b())) {
            return false;
        }
        FungiShape[] shapes = FungiShape.values();
        FungiShape shape = shapes[rand.nextInt(shapes.length)];
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings placementSettings = this.buildPlacementSettings(rand);
        ResourceLocation stemTemplateId = shape.getStemTemplate(rand);
        ResourceLocation hatTemplateId = shape.getHatTemplate(rand);
        Template stemTemplate = templateManager.func_186237_a(server, stemTemplateId);
        Template hatTemplate = templateManager.func_186237_a(server, hatTemplateId);
        BlockPos correctedOrigin = this.computeCorrectedOrigin(origin, stemTemplate, placementSettings);
        if (correctedOrigin == null) {
            Midnight.LOGGER.warn("Template '{}' did not have required 'origin' data block", (Object)hatTemplateId);
            return false;
        }
        Map stemData = stemTemplate.func_186258_a(correctedOrigin, placementSettings);
        BlockPos hatAttachment = this.reverseLookup(stemData, "hat");
        if (hatAttachment == null) {
            Midnight.LOGGER.warn("Template '{}' did not have required 'hat' data block", (Object)stemTemplateId);
            return false;
        }
        BlockPos hatOrigin = this.computeCorrectedOrigin(hatAttachment, hatTemplate, placementSettings);
        if (hatOrigin == null) {
            Midnight.LOGGER.warn("Template '{}' did not have required 'origin' data block", (Object)hatTemplateId);
            return false;
        }
        BlockPos minPos = WorldUtil.min(correctedOrigin, hatAttachment);
        BlockPos maxPos = WorldUtil.max(correctedOrigin, hatAttachment);
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)minPos, (BlockPos)maxPos)) {
            if (this.canReplace(world, pos)) continue;
            return false;
        }
        stemTemplate.func_189960_a(world, correctedOrigin, this::processState, placementSettings, 18);
        hatTemplate.func_189960_a(world, hatOrigin, this::processState, placementSettings, 18);
        HashMap<BlockPos, String> globalData = new HashMap<BlockPos, String>(stemData);
        globalData.putAll(hatTemplate.func_186258_a(hatOrigin, placementSettings));
        this.processDataBlocks(world, globalData);
        this.attachShelfBlocks(world, rand, hatOrigin, hatTemplate, placementSettings);
        return true;
    }

    private boolean canGrow(World world, BlockPos groundPos) {
        IBlockState groundState = world.func_180495_p(groundPos);
        Block groundBlock = groundState.func_177230_c();
        return groundBlock == ModBlocks.MIDNIGHT_GRASS || groundBlock == ModBlocks.MIDNIGHT_DIRT || groundBlock == ModBlocks.MIDNIGHT_MYCELIUM || groundBlock == ModBlocks.NIGHTSTONE || groundBlock == Blocks.field_150391_bh;
    }

    private Template.BlockInfo processState(World world, BlockPos pos, Template.BlockInfo info) {
        IBlockState state = info.field_186243_b;
        if (state.func_177230_c() instanceof BlockMidnightFungiStem) {
            return new Template.BlockInfo(pos, this.stem, null);
        }
        if (state.func_177230_c() instanceof BlockMidnightFungiHat) {
            return new Template.BlockInfo(pos, this.hat, null);
        }
        if (state.func_177230_c() == Blocks.field_185779_df || state.func_177230_c() == Blocks.field_150350_a) {
            return null;
        }
        return info;
    }

    private void attachShelfBlocks(World world, Random random, BlockPos hatOrigin, Template hatTemplate, PlacementSettings placementSettings) {
        for (Template.BlockInfo block : hatTemplate.field_186270_a) {
            IBlockState state = block.field_186243_b;
            if (!(state.func_177230_c() instanceof BlockMidnightFungiHat) || random.nextInt(6) != 0) continue;
            BlockPos transformedPos = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)block.field_186242_a).func_177971_a((Vec3i)hatOrigin);
            this.attachShelf(world, random, transformedPos);
        }
    }

    private void attachShelf(World world, Random random, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        List<EnumFacing> attachSides = BlockMidnightFungiHat.getOuterSides(state.func_185899_b((IBlockAccess)world, pos));
        attachSides.remove(EnumFacing.DOWN);
        if (!attachSides.isEmpty()) {
            Block shelfBlock = SHELF_BLOCKS[random.nextInt(SHELF_BLOCKS.length)];
            EnumFacing attachSide = attachSides.get(random.nextInt(attachSides.size()));
            BlockPos offsetPos = pos.func_177972_a(attachSide);
            if (this.canReplace(world, offsetPos)) {
                world.func_175656_a(offsetPos, shelfBlock.func_176223_P().func_177226_a((IProperty)BlockMidnightFungiShelf.FACING, (Comparable)attachSide));
            }
        }
    }

    private void processDataBlocks(World world, Map<BlockPos, String> globalData) {
        for (Map.Entry<BlockPos, String> entry : globalData.entrySet()) {
            BlockPos pos = entry.getKey();
            String tag = entry.getValue();
            if (tag.equals("inside")) {
                world.func_180501_a(pos, ModBlocks.MUSHROOM_INSIDE.func_176223_P(), 18);
                continue;
            }
            if (!tag.equals("origin")) continue;
            world.func_180501_a(pos, this.stem, 18);
        }
    }

    @Nullable
    private BlockPos computeCorrectedOrigin(BlockPos origin, Template template, PlacementSettings placementSettings) {
        Map dataBlocks = template.func_186258_a(BlockPos.field_177992_a, placementSettings);
        BlockPos localOrigin = this.reverseLookup(dataBlocks, "origin");
        if (localOrigin == null) {
            return null;
        }
        return origin.func_177973_b((Vec3i)localOrigin);
    }

    private PlacementSettings buildPlacementSettings(Random rand) {
        Rotation[] rotations = Rotation.values();
        Mirror[] mirrors = Mirror.values();
        return new PlacementSettings().func_186220_a(rotations[rand.nextInt(rotations.length)]).func_186214_a(mirrors[rand.nextInt(mirrors.length)]);
    }

    @Nullable
    private BlockPos reverseLookup(Map<BlockPos, String> data, String value) {
        for (Map.Entry<BlockPos, String> entry : data.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public DecorateBiomeEvent.Decorate.EventType getEventType() {
        return DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM;
    }

    private static enum FungiShape {
        FLAT(new String[]{"mushroom_stem_flat_1", "mushroom_stem_flat_2"}, new String[]{"mushroom_hat_flat_1"}),
        SLANT(new String[]{"mushroom_stem_slant_1", "mushroom_stem_slant_2"}, new String[]{"mushroom_hat_slant_1"});

        private final String[] stemTemplates;
        private final String[] hatTemplates;

        private FungiShape(String[] stemTemplates, String[] hatTemplates) {
            this.stemTemplates = stemTemplates;
            this.hatTemplates = hatTemplates;
        }

        public ResourceLocation getStemTemplate(Random random) {
            String template = this.stemTemplates[random.nextInt(this.stemTemplates.length)];
            return new ResourceLocation("midnight", "mushroom/" + template);
        }

        public ResourceLocation getHatTemplate(Random random) {
            String template = this.hatTemplates[random.nextInt(this.hatTemplates.length)];
            return new ResourceLocation("midnight", "mushroom/" + template);
        }
    }
}

