/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.world.feature.MidnightTreeFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.IntFunction;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ShadowrootTreeFeature
extends MidnightTreeFeature {
    private static final int BRANCH_SPACING = 3;

    public ShadowrootTreeFeature(IBlockState log, IBlockState leaves) {
        super(log, leaves);
    }

    public ShadowrootTreeFeature() {
        this(ModBlocks.SHADOWROOT_LOG.func_176223_P(), ModBlocks.SHADOWROOT_LEAVES.func_176223_P());
    }

    @Override
    public boolean placeFeature(World world, Random random, BlockPos origin) {
        IntFunction<Integer> widthSupplier;
        int height = random.nextInt(8) + 10;
        if (!this.canFit(world, origin, height, widthSupplier = y -> 1)) {
            return false;
        }
        if (this.canGrow(world, origin)) {
            this.notifyGrowth(world, origin);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(origin);
            for (int localY = 0; localY < height; ++localY) {
                mutablePos.func_185336_p(origin.func_177956_o() + localY);
                this.placeLog(world, (BlockPos)mutablePos);
            }
            this.generateRoots(world, random, origin);
            Set<Branch> branches = this.collectBranches(world, random, origin, height);
            for (Branch branch : branches) {
                this.placeLog(world, branch.pos, branch.getAxis());
            }
            Set<BlockPos> leafPositions = this.produceBlob(origin.func_177981_b(height - 2), 1.5, 2.5);
            leafPositions = this.droopLeaves(leafPositions, random, 4);
            for (Branch branch : branches) {
                leafPositions.addAll(this.collectBranchLeaves(branch, random));
            }
            for (BlockPos leafPos : leafPositions) {
                this.placeLeaves(world, leafPos);
            }
            return true;
        }
        return false;
    }

    private void generateRoots(World world, Random random, BlockPos origin) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ArrayList availableSides = new ArrayList(4);
        Collections.addAll(availableSides, EnumFacing.field_176754_o);
        int count = random.nextInt(3) + 1;
        for (int i = 0; i < count; ++i) {
            EnumFacing side = (EnumFacing)availableSides.remove(random.nextInt(availableSides.size()));
            BlockPos rootOrigin = origin.func_177972_a(side);
            int height = random.nextInt(3) + 1;
            for (int localY = 0; localY < height; ++localY) {
                mutablePos.func_181079_c(rootOrigin.func_177958_n(), rootOrigin.func_177956_o() + localY, rootOrigin.func_177952_p());
                this.placeLog(world, (BlockPos)mutablePos);
            }
        }
    }

    private Set<BlockPos> droopLeaves(Set<BlockPos> leafPositions, Random random, int amount) {
        HashSet<BlockPos> droopedLeaves = new HashSet<BlockPos>(leafPositions);
        for (BlockPos pos : leafPositions) {
            int droopAmount = random.nextInt(amount);
            for (int i = 0; i < droopAmount; ++i) {
                droopedLeaves.add(pos.func_177979_c(i));
            }
        }
        return droopedLeaves;
    }

    private Set<Branch> collectBranches(World world, Random random, BlockPos origin, int height) {
        int minBranchHeight = 3;
        int maxBranchHeight = height - 4;
        int heightRange = maxBranchHeight - minBranchHeight;
        HashSet<Branch> branches = new HashSet<Branch>();
        int branchCount = heightRange / 3;
        double normalizedSpacing = (double)heightRange / (double)branchCount;
        EnumFacing lastDirection = null;
        for (int branch = 0; branch < branchCount; ++branch) {
            int y = MathHelper.func_76143_f((double)((double)(minBranchHeight + 1) + (double)branch * normalizedSpacing));
            EnumFacing direction = null;
            while (direction == null || direction == lastDirection) {
                direction = EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)];
            }
            lastDirection = direction;
            BlockPos branchPos = origin.func_177981_b(y).func_177972_a(direction);
            if (!this.canReplace(world, branchPos)) continue;
            float outerAngle = direction.func_185119_l();
            float angle = random.nextFloat() * 90.0f + outerAngle - 45.0f;
            branches.add(new Branch(branchPos, direction, angle));
        }
        return branches;
    }

    private Set<BlockPos> collectBranchLeaves(Branch branch, Random random) {
        HashSet<BlockPos> branchLeaves = new HashSet<BlockPos>();
        float theta = (float)Math.toRadians(branch.angle);
        float deltaX = -MathHelper.func_76126_a((float)theta);
        float deltaZ = MathHelper.func_76134_b((float)theta);
        for (int step = 0; step < 3; ++step) {
            int droop = -step / 2 + 1;
            BlockPos origin = branch.pos.func_177963_a((double)(deltaX * (float)step), (double)droop, (double)(deltaZ * (float)step));
            Set<BlockPos> stepLeaves = this.produceBlob(origin, 1.0);
            branchLeaves.addAll(this.droopLeaves(stepLeaves, random, step + 1));
        }
        return branchLeaves;
    }

    private static class Branch {
        final BlockPos pos;
        final EnumFacing direction;
        final float angle;

        private Branch(BlockPos pos, EnumFacing direction, float angle) {
            this.pos = pos;
            this.direction = direction;
            this.angle = angle;
        }

        public BlockLog.EnumAxis getAxis() {
            switch (this.direction.func_176740_k()) {
                case X: {
                    return BlockLog.EnumAxis.X;
                }
                case Z: {
                    return BlockLog.EnumAxis.Z;
                }
            }
            return BlockLog.EnumAxis.Y;
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Branch && ((Branch)obj).pos.equals((Object)this.pos);
        }
    }
}

