/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.common.world.feature.MidnightAbstractFeature;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SpikeFeature
extends MidnightAbstractFeature {
    private final IBlockState state;

    public SpikeFeature(IBlockState state) {
        this.state = state;
    }

    @Override
    public boolean placeFeature(World world, Random random, BlockPos origin) {
        while (world.func_175623_d(origin) && origin.func_177956_o() > 2) {
            origin = origin.func_177977_b();
        }
        origin = origin.func_177981_b(random.nextInt(4));
        int height = random.nextInt(4) + 7;
        int baseRadius = Math.max(height / 4 + random.nextInt(2), 2);
        for (int y = 0; y < height; ++y) {
            float radius = (1.0f - (float)y / (float)height) * (float)baseRadius;
            int bound = MathHelper.func_76123_f((float)radius);
            for (int x = -bound; x <= bound; ++x) {
                float deltaX = (float)MathHelper.func_76130_a((int)x) - 0.25f;
                for (int z = -bound; z <= bound; ++z) {
                    BlockPos inversePos;
                    float deltaZ = (float)MathHelper.func_76130_a((int)z) - 0.25f;
                    if ((x != 0 || z != 0) && !(deltaX * deltaX + deltaZ * deltaZ <= radius * radius) || (x == -bound || x == bound || z == -bound || z == bound) && !(random.nextFloat() <= 0.75f)) continue;
                    BlockPos pos = origin.func_177982_a(x, y, z);
                    if (this.canReplace(world, pos)) {
                        this.func_175903_a(world, pos, this.state);
                    }
                    if (y == 0 || bound <= 1 || !this.canReplace(world, inversePos = origin.func_177982_a(x, -y, z))) continue;
                    this.func_175903_a(world, inversePos, this.state);
                }
            }
        }
        return true;
    }

    private boolean canReplace(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b;
    }
}

