/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.block.BlockMidnightFungiHat;
import com.mushroom.midnight.common.block.BlockMidnightFungiStem;
import com.mushroom.midnight.common.util.WorldUtil;
import com.mushroom.midnight.common.world.feature.MidnightTreeFeature;
import com.mushroom.midnight.common.world.template.CompiledTemplate;
import com.mushroom.midnight.common.world.template.RotatedSettingConfigurator;
import com.mushroom.midnight.common.world.template.TemplateCompiler;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;

public class TemplateTreeFeature
extends MidnightTreeFeature {
    private static final String ANCHOR_KEY = "origin";
    private static final String TRUNK_TOP_KEY = "trunk_top";
    private static final String TRUNK_CORNER_KEY = "trunk_corner";
    private final ResourceLocation[] templates;
    private TemplateCompiler templateCompiler;

    public TemplateTreeFeature(ResourceLocation[] templates, IBlockState log, IBlockState leaves) {
        super(log, leaves);
        this.templates = templates;
    }

    protected TemplateCompiler buildCompiler(ResourceLocation[] templates) {
        return TemplateCompiler.of(templates).withAnchor(ANCHOR_KEY).withSettingConfigurator(RotatedSettingConfigurator.INSTANCE).withProcessor(this::processState).withDataProcessor(this::processData);
    }

    @Override
    public boolean placeFeature(World world, Random rand, BlockPos origin) {
        BlockPos maxCorner;
        if (!this.canGrow(world, origin)) {
            return false;
        }
        if (this.templateCompiler == null) {
            this.templateCompiler = this.buildCompiler(this.templates);
        }
        CompiledTemplate template = this.templateCompiler.compile(world, rand, origin);
        BlockPos trunkTop = template.lookupAny(TRUNK_TOP_KEY);
        Collection<BlockPos> trunkCorners = template.lookup(TRUNK_CORNER_KEY);
        if (trunkTop == null || trunkCorners.isEmpty()) {
            Midnight.LOGGER.warn("Template '{}' did not have required '{}' and '{}' data blocks", (Object)template, (Object)TRUNK_TOP_KEY, (Object)TRUNK_CORNER_KEY);
            return false;
        }
        BlockPos minCorner = WorldUtil.min(trunkCorners).func_177982_a(1, 0, 1);
        if (!this.canGrow(world, minCorner, maxCorner = WorldUtil.max(trunkCorners).func_177982_a(-1, 0, -1)) || !this.canFit(world, trunkTop, minCorner, maxCorner)) {
            return false;
        }
        this.notifyGrowth(world, origin);
        template.addTo(world, rand, 18);
        return true;
    }

    protected boolean canGrow(World world, BlockPos minCorner, BlockPos maxCorner) {
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)minCorner, (BlockPos)maxCorner)) {
            if (this.canGrow(world, pos)) continue;
            return false;
        }
        return true;
    }

    protected boolean canFit(World world, BlockPos trunkTop, BlockPos minCorner, BlockPos maxCorner) {
        BlockPos maxFit = new BlockPos(maxCorner.func_177958_n(), trunkTop.func_177956_o(), maxCorner.func_177952_p());
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)minCorner, (BlockPos)maxFit)) {
            if (this.canReplace(world, pos)) continue;
            return false;
        }
        return true;
    }

    protected Template.BlockInfo processState(World world, BlockPos pos, Template.BlockInfo info) {
        IBlockState state = info.field_186243_b;
        Block block = state.func_177230_c();
        if (block instanceof BlockLog) {
            BlockLog.EnumAxis axis = (BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a);
            return new Template.BlockInfo(pos, this.log.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis), null);
        }
        if (block instanceof BlockMidnightFungiStem) {
            return new Template.BlockInfo(pos, this.log, null);
        }
        if (block instanceof BlockLeaves || block instanceof BlockMidnightFungiHat) {
            return new Template.BlockInfo(pos, this.leaves, null);
        }
        if (block == Blocks.field_185779_df || block instanceof BlockAir) {
            return null;
        }
        return info;
    }

    protected void processData(World world, BlockPos pos, String key) {
        if (key.equals(ANCHOR_KEY) || key.equals(TRUNK_TOP_KEY)) {
            world.func_180501_a(pos, this.log, 18);
        }
    }
}

