/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.generator;

import com.google.common.base.Predicate;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.registry.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class MidnightOreGenerator
implements IWorldGenerator {
    private static final long SEED = 21052088057241959L;
    private static final BlockMatcher NIGHTSTONE_MATCHER = BlockMatcher.func_177642_a((Block)ModBlocks.NIGHTSTONE);
    private static final WorldGenerator DARK_PEARL_GENERATOR = new WorldGenMinable(ModBlocks.DARK_PEARL_ORE.func_176223_P(), 14, (Predicate)NIGHTSTONE_MATCHER);
    private static final WorldGenerator TENEBRUM_GENERATOR = new WorldGenMinable(ModBlocks.TENEBRUM_ORE.func_176223_P(), 4, (Predicate)NIGHTSTONE_MATCHER);
    private static final WorldGenerator NAGRILITE_GENERATOR = new WorldGenMinable(ModBlocks.NAGRILITE_ORE.func_176223_P(), 4, (Predicate)NIGHTSTONE_MATCHER);
    private static final WorldGenerator EBONYS_GENERATOR = new WorldGenMinable(ModBlocks.EBONYS_ORE.func_176223_P(), 6, (Predicate)NIGHTSTONE_MATCHER);
    private static final int DARK_PEARL_PER_CHUNK = 8;
    private static final int TENEBRUM_PER_CHUNK = 6;
    private static final int NAGRILITE_PER_CHUNK = 4;
    private static final int EBONYS_PER_CHUNK = 4;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        int f;
        int offsetZ;
        int offsetY;
        int offsetX;
        if (!Helper.isMidnightDimension(world)) {
            return;
        }
        random.setSeed(random.nextLong() ^ 0x4ACAC3366EA167L);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int globalX = chunkX << 4;
        int globalZ = chunkZ << 4;
        for (int i = 0; i < 8; ++i) {
            offsetX = random.nextInt(16);
            offsetY = random.nextInt(56);
            offsetZ = random.nextInt(16);
            pos.func_181079_c(globalX + offsetX, offsetY, globalZ + offsetZ);
            DARK_PEARL_GENERATOR.func_180709_b(world, random, (BlockPos)pos);
        }
        for (f = 0; f < 6; ++f) {
            offsetX = random.nextInt(16);
            offsetY = random.nextInt(56);
            offsetZ = random.nextInt(16);
            pos.func_181079_c(globalX + offsetX, offsetY, globalZ + offsetZ);
            TENEBRUM_GENERATOR.func_180709_b(world, random, (BlockPos)pos);
        }
        for (f = 0; f < 4; ++f) {
            offsetX = random.nextInt(16);
            offsetY = random.nextInt(24);
            offsetZ = random.nextInt(16);
            pos.func_181079_c(globalX + offsetX, offsetY, globalZ + offsetZ);
            NAGRILITE_GENERATOR.func_180709_b(world, random, (BlockPos)pos);
        }
        for (f = 0; f < 4; ++f) {
            offsetX = random.nextInt(16);
            offsetY = random.nextInt(24);
            offsetZ = random.nextInt(16);
            pos.func_181079_c(globalX + offsetX, offsetY, globalZ + offsetZ);
            EBONYS_GENERATOR.func_180709_b(world, random, (BlockPos)pos);
        }
    }
}

