/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.generator;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.BiomeLayerSampler;
import com.mushroom.midnight.common.biome.MidnightBiomeLayer;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.capability.MultiLayerBiomeSampler;
import com.mushroom.midnight.common.registry.ModBlocks;
import java.util.Arrays;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenCaves;

public class WorldGenMidnightCaves
extends MapGenCaves {
    protected void func_180701_a(World world, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer primer) {
        int nodeCount = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(15) + 1) + 1);
        if (this.field_75038_b.nextInt(7) != 0) {
            nodeCount = 0;
        }
        for (int i = 0; i < nodeCount; ++i) {
            double startX = (chunkX << 4) + this.field_75038_b.nextInt(16);
            double startY = this.field_75038_b.nextInt(this.field_75038_b.nextInt(world.func_181545_F() * 2) + 8);
            double startZ = (chunkZ << 4) + this.field_75038_b.nextInt(16);
            int branchCount = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.func_180703_a(this.field_75038_b.nextLong(), originalX, originalZ, primer, startX, startY, startZ);
                branchCount += this.field_75038_b.nextInt(4);
            }
            for (int branch = 0; branch < branchCount; ++branch) {
                float horizAngle = this.field_75038_b.nextFloat() * ((float)Math.PI * 2);
                float vertAngle = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float radius = this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    radius *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.0f + 1.0f;
                }
                this.func_180702_a(this.field_75038_b.nextLong(), originalX, originalZ, primer, startX, startY, startZ, radius, horizAngle, vertAngle, 0, 0, 1.0);
            }
        }
    }

    protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, IBlockState state, IBlockState up) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState top = biome.field_76752_A;
        IBlockState filler = biome.field_76753_B;
        if (this.func_175793_a(state, up) || state.func_177230_c() == top.func_177230_c() || state.func_177230_c() == filler.func_177230_c()) {
            if (y > 10) {
                data.func_177855_a(x, y, z, field_186127_b);
                if (foundTop && data.func_177856_a(x, y - 1, z).func_177230_c() == filler.func_177230_c()) {
                    data.func_177855_a(x, y - 1, z, top.func_177230_c().func_176223_P());
                }
            } else {
                data.func_177855_a(x, y, z, ModBlocks.MIASMA.func_176223_P());
            }
        }
    }

    protected boolean func_175793_a(IBlockState state, IBlockState aboveState) {
        Material material = state.func_185904_a();
        Material aboveMaterial = aboveState.func_185904_a();
        return (material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b) && material != Material.field_151586_h && material != Material.field_151587_i && aboveMaterial != Material.field_151586_h && aboveMaterial != Material.field_151587_i;
    }

    protected void func_180702_a(long seed, int originChunkX, int originChunkZ, ChunkPrimer primer, double x, double y, double z, float radius, float yaw, float pitch, int p_180702_15_, int p_180702_16_, double length) {
        float caveRadiusScale = this.getRadiusScale(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)z));
        if (caveRadiusScale <= 0.01f) {
            return;
        }
        super.func_180702_a(seed, originChunkX, originChunkZ, primer, x, y, z, radius * caveRadiusScale, yaw, pitch, p_180702_15_, p_180702_16_, length);
    }

    private float getRadiusScale(int x, int z) {
        BiomeLayerSampler<CavernousBiome> undergroundLayer;
        MultiLayerBiomeSampler multiLayerSampler = (MultiLayerBiomeSampler)this.field_75039_c.getCapability(Midnight.MULTI_LAYER_BIOME_SAMPLER_CAP, null);
        if (multiLayerSampler != null && (undergroundLayer = multiLayerSampler.getLayer(MidnightBiomeLayer.UNDERGROUND)) != null) {
            float current = WorldGenMidnightCaves.getRadiusScale(undergroundLayer.sample(x, z));
            float west = WorldGenMidnightCaves.getRadiusScale(undergroundLayer.sample(x - 16, z));
            float east = WorldGenMidnightCaves.getRadiusScale(undergroundLayer.sample(x + 16, z));
            float north = WorldGenMidnightCaves.getRadiusScale(undergroundLayer.sample(x, z - 16));
            float south = WorldGenMidnightCaves.getRadiusScale(undergroundLayer.sample(x, z + 16));
            return (float)WorldGenMidnightCaves.max(current, west, east, north, south);
        }
        return 1.0f;
    }

    private static double max(double ... values) {
        return Arrays.stream(values).max().orElse(0.0);
    }

    private static float getRadiusScale(CavernousBiome biome) {
        return biome.getConfig().getStructureConfig().getCaveRadiusScale();
    }
}

