/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public class ItemBlockGrave
extends ItemBlock {
    public ItemBlockGrave(Block block) {
        super(block);
        this.func_185043_a(new ResourceLocation("model_texture"), (stack, world, entity) -> EngravableHelper.isEngraved(stack) ? 0.1f : 0.0f);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String engravedName = EngravableHelper.getEngravedName(stack);
        if (!engravedName.isEmpty()) {
            tooltip.add(LangKey.MESSAGE_ENGRAVED.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, '\"' + engravedName + '\"'));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            items.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String itemName = LangKey.makeServerTranslation(stack.func_77977_a() + ".name", new Object[0]);
        return EngravableHelper.isEngraved(stack) ? LangKey.MESSAGE_ENGRAVED_ITEM.getServerTranslation(itemName) : itemName;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        return world.func_180495_p(pos.func_177977_b()).func_185898_k() && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        assert (this.getRegistryName() != null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_black", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_white", "inventory"));
    }
}

