/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class CommandTBTeleportGrave
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbteleportgrave";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = args.length <= 1 ? CommandTBTeleportGrave.func_71521_c((ICommandSender)sender) : CommandTBTeleportGrave.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        CommandTBTeleportGrave.checkAlive((Entity)player);
        CommandTBTeleportGrave.checkNotSpectator((EntityPlayer)player);
        if (player.field_70170_p == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        String targetName = args.length == 0 ? player.func_70005_c_() : CommandTBTeleportGrave.func_184886_d((MinecraftServer)server, (ICommandSender)sender, (String)args[args.length - 1]);
        Location lastGrave = deathHandler.getLastGrave(targetName);
        if (!lastGrave.isOrigin() && !(server.func_71218_a(lastGrave.dim).func_175625_s(lastGrave.getPos()) instanceof TileEntityTombstone)) {
            deathHandler.removeGrave(lastGrave);
            lastGrave = Location.ORIGIN;
        }
        if (lastGrave.isOrigin()) {
            lastGrave = ModItems.grave_key.getTombPos(ModItems.grave_key.findFirstKeyInInventory((EntityPlayer)player));
        }
        if (lastGrave.isOrigin()) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_GRAVE.getKey(), new Object[0]);
        }
        if (!Helper.isValidDimension(lastGrave.dim)) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_DIMENSION.getKey(), new Object[0]);
        }
        CommandTBTeleportGrave.checkValidPos((World)server.func_71218_a(lastGrave.dim), lastGrave.getPos());
        Helper.teleportToGrave(player, lastGrave);
        CommandTBTeleportGrave.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_LOG_TELEPORT_SUCCESS.getKey(), (Object[])new Object[]{targetName, lastGrave.x, lastGrave.y, lastGrave.z, lastGrave.dim});
        LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0 || index == 1;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 0 || args.length > 2) {
            return Collections.emptyList();
        }
        List<String> graveList = DeathHandler.INSTANCE.getLastGraveList();
        if (args.length == 2) {
            return CommandTBTeleportGrave.func_175762_a((String[])args, graveList);
        }
        HashSet playerList = Sets.newHashSet((Object[])server.func_71213_z());
        playerList.addAll(graveList);
        return CommandTBTeleportGrave.func_175762_a((String[])args, (Collection)playerList);
    }
}

