/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.WeaponEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;

public class EnchantmentMagicSiphon
extends WeaponEnchantment {
    public EnchantmentMagicSiphon() {
        super("magic_siphon", Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
    }

    @Override
    protected boolean isEnabled() {
        return ConfigTombstone.enchantments.isEnableEnchantmentMagicSiphon();
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && (ConfigTombstone.enchantments.allowPlagueBringerCombiningWithMagicSiphon() || ench != ModEnchantments.plague_bringer);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigTombstone.enchantments.allowMagicSiphonAtEnchantingTable() && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public int func_77325_b() {
        return ConfigTombstone.enchantments.getMaxLevelMagicSiphon();
    }

    @Override
    public void onProc(EntityLivingBase attacker, EntityLivingBase target, int level) {
        List effects = target.func_70651_bq().stream().filter(EffectHelper::isAllowedEffect).collect(Collectors.toList());
        if (!effects.isEmpty()) {
            PotionEffect effectInstance = (PotionEffect)effects.get(Helper.random.nextInt(effects.size()));
            int stolenDuration = Math.min(TimeHelper.tickFromMinute(ConfigTombstone.enchantments.maxDurationMagicSiphon), effectInstance.field_76460_b / (ConfigTombstone.enchantments.magicSiphonOnPlayerRule == ConfigTombstone.CatEnchantments.MagicSiphonOnPlayerRule.NERFED && EntityHelper.isValidPlayer((Entity)target) ? 10 : 1));
            if (stolenDuration < 3) {
                return;
            }
            PotionEffect effectCopy = new PotionEffect(effectInstance);
            effectCopy.field_76460_b = stolenDuration;
            attacker.func_70690_d(effectCopy);
            EffectHelper.clearEffect(target, effectInstance.func_188419_a());
            if (stolenDuration < effectInstance.field_76460_b) {
                effectInstance.field_76460_b -= stolenDuration;
                target.func_70690_d(effectInstance);
            }
            if (target.func_110143_aJ() > target.func_110138_aP()) {
                target.func_70606_j(target.func_110138_aP());
            }
        }
    }

    @Override
    protected boolean canAffectTarget(EntityLivingBase target) {
        return ConfigTombstone.enchantments.magicSiphonOnPlayerRule != ConfigTombstone.CatEnchantments.MagicSiphonOnPlayerRule.DISALLOW || !EntityHelper.isValidPlayer((Entity)target);
    }
}

