/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.FakePlayer;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;

public class EntityHelper {
    public static boolean hasEnchantment(EntityLivingBase entity, Enchantment ench) {
        return EntityHelper.hasEnchantment(entity, ench, 1);
    }

    public static boolean hasEnchantment(EntityLivingBase entity, Enchantment ench, int lvl) {
        for (ItemStack stack : ench.func_185260_a(entity)) {
            if (EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) < lvl) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(EntityLivingBase entity, Enchantment ench) {
        int lvl = 0;
        for (ItemStack stack : ench.func_185260_a(entity)) {
            int currentLvl = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack);
            if (currentLvl <= lvl) continue;
            lvl = currentLvl;
        }
        return lvl;
    }

    public static boolean isValidPlayer(@Nullable ICommandSender sender) {
        return sender instanceof EntityPlayer && !(sender instanceof FakePlayer);
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof EntityPlayer && !(entity instanceof FakePlayer);
    }

    public static boolean isValidServerPlayer(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.field_70170_p.field_72995_K;
    }

    public static boolean isValidPlayer(@Nullable EntityPlayer player) {
        return player != null && !(player instanceof FakePlayer);
    }

    public static boolean isSurvivalPlayer(@Nullable EntityPlayer player) {
        return EntityHelper.isValidPlayer(player) && !player.func_184812_l_() && !player.func_175149_v();
    }

    public static Optional<Location> getHomeLocation(EntityLivingBase entity) {
        return entity instanceof EntityCreature ? Optional.of(new Location(((EntityCreature)entity).func_180486_cf(), entity.field_70170_p)) : Optional.empty();
    }

    public static void setPlayerXp(EntityPlayer player, int amount) {
        if (amount < 0) {
            return;
        }
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.field_71106_cc = 0.0f;
        player.field_71106_cc += (float)amount / (float)player.func_71050_bK();
        player.field_71067_cb += amount;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ++player.field_71068_ca;
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static int getPlayerTotalXp(EntityPlayer player) {
        return EntityHelper.getPlayerTotalXp(player.field_71068_ca, player.field_71106_cc);
    }

    public static int getPlayerTotalXp(int level, float bar) {
        int experienceTotal;
        if (level < 17) {
            experienceTotal = level * level + 6 * level;
            experienceTotal = (int)((float)experienceTotal + (float)(2 * level + 7) * bar);
        } else if (level < 32) {
            experienceTotal = (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
            experienceTotal = (int)((float)experienceTotal + (float)(5 * level - 38) * bar);
        } else {
            experienceTotal = (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
            experienceTotal = (int)((float)experienceTotal + (float)(9 * level - 158) * bar);
        }
        return experienceTotal;
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static boolean hasGlobalItemCooldown(@Nullable EntityPlayer player, Item item) {
        return EntityHelper.getGlobalItemCooldown(player, item) != 0.0f;
    }

    public static boolean hasGlobalItemCooldown(@Nullable EntityPlayer player, ItemStack stack) {
        return EntityHelper.hasGlobalItemCooldown(player, stack.func_77973_b());
    }

    public static void setGlobalItemCooldown(EntityPlayer player, Item item, int ticks) {
        player.func_184811_cZ().func_185145_a(item, ticks);
    }

    public static void setGlobalItemCooldown(EntityPlayer player, ItemStack stack, int ticks) {
        EntityHelper.setGlobalItemCooldown(player, stack.func_77973_b(), ticks);
    }

    public static float getGlobalItemCooldown(@Nullable EntityPlayer player, Item item) {
        return player != null ? player.func_184811_cZ().func_185143_a(item, 0.0f) : 0.0f;
    }

    public static float getGlobalItemCooldown(@Nullable EntityPlayer player, ItemStack stack) {
        return EntityHelper.getGlobalItemCooldown(player, stack.func_77973_b());
    }

    public static void applyAlignmentOnKill(DamageSource damageSource, Entity killedEntity) {
        if (EntityHelper.isValidServerPlayer(damageSource.func_76346_g())) {
            EntityPlayerMP player = (EntityPlayerMP)damageSource.func_76346_g();
            assert (player != null);
            if (!CompatibilityMinecolonies.instance.applyKillResult(player, EntityList.func_191301_a((Entity)killedEntity))) {
                if (killedEntity instanceof EntityVillager) {
                    EntityHelper.addAlignment(player, ConfigTombstone.alignment.pointsKillVillager);
                } else if (killedEntity instanceof EntityZombie && killedEntity.getEntityData().func_74767_n("siege")) {
                    EntityHelper.addAlignment(player, ConfigTombstone.alignment.pointsKillRaider, ConfigTombstone.alignment.chanceKillRaider);
                }
            }
        }
    }

    public static long getKnowledge(EntityPlayer player) {
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        return cap != null ? cap.getKnowledge() : 0L;
    }

    public static void addKnowledge(EntityPlayerMP player, long points) {
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap != null) {
            cap.addKnowledgeAndSync(player, points);
        }
    }

    public static void removeKnowledge(EntityPlayerMP player, long points) {
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap != null) {
            cap.removeKnowledgeAndSync(player, points);
        }
    }

    public static void addAlignment(EntityPlayerMP player, int amount, int chanceOn100) {
        if ((chanceOn100 = MathHelper.func_76125_a((int)chanceOn100, (int)0, (int)100)) > 0 && Helper.random.nextInt(100) < chanceOn100) {
            EntityHelper.addAlignment(player, amount);
        }
    }

    public static void addAlignment(EntityPlayerMP player, int amount) {
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap != null) {
            cap.addAlignmentAndSync(player, amount);
        }
    }

    public static boolean isBadAlignment(EntityPlayerMP player) {
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        return cap != null && cap.getAlignmentLevel() < 0;
    }

    public static int getPerkLevelWithBonus(@Nullable EntityPlayer player, @Nullable Perk perk) {
        ITBCapability cap;
        if (EntityHelper.isValidPlayer(player) && (cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null) {
            return cap.getPerkLevelWithBonus(player, perk);
        }
        return 0;
    }

    public static boolean canPray(@Nullable EntityPlayer player) {
        ITBCapability cap;
        return player != null && (cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null && cap.canPray(player);
    }

    public static void syncTBCapability(EntityPlayerMP player) {
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap != null) {
            cap.syncAll(player);
        }
    }

    public static NBTTagCompound getPersistentTag(EntityPlayer player) {
        NBTTagCompound persistentData = player.getEntityData();
        if (persistentData.func_74764_b("PlayerPersisted")) {
            NBTTagCompound persistentTag = (NBTTagCompound)persistentData.func_74781_a("PlayerPersisted");
            return persistentTag;
        }
        NBTTagCompound persistentTag = new NBTTagCompound();
        persistentData.func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        return persistentTag;
    }
}

