/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ovh.corail.tombstone.helper.EffectHelper;

public class EffectMessage
implements IMessage {
    private int entityId;
    private PotionEffect effectInstance;

    public EffectMessage() {
    }

    public EffectMessage(int entityId, PotionEffect effectInstance) {
        this.entityId = entityId;
        this.effectInstance = effectInstance;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        NBTTagCompound effect = ByteBufUtils.readTag((ByteBuf)buf);
        this.effectInstance = effect == null ? new PotionEffect(MobEffects.field_76443_y) : PotionEffect.func_82722_b((NBTTagCompound)effect);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.effectInstance.func_82719_a(new NBTTagCompound()));
    }

    public static class Handler
    implements IMessageHandler<EffectMessage, IMessage> {
        public IMessage onMessage(final EffectMessage message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Minecraft mainThread = Minecraft.func_71410_x();
                mainThread.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
                        if (entity instanceof EntityLivingBase) {
                            EffectHelper.addPotion((EntityLivingBase)entity, message.effectInstance);
                        }
                    }
                });
            }
            return null;
        }
    }
}

