/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public class PerkMementoMori
extends Perk {
    PerkMementoMori() {
        super("memento_mori", new ResourceLocation("minecraft", "textures/items/experience_bottle.png"));
    }

    @Override
    public int getLevelMax() {
        return ConfigTombstone.general.getXpLoss() / 20;
    }

    @Override
    public boolean isDisabled() {
        return !ConfigTombstone.general.isHandlingPlayerXp() || ConfigTombstone.general.getXpLoss() < 20;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return "+" + level * 20 + "% " + LangKey.makeClientTranslation("tombstone.perk.memento_mori.desc", new Object[0]);
        }
        if (level == actualLevel + 1) {
            return "+" + level * 20 + "%";
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? level : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_ACTUAL_BONUS.getClientTranslationWithStyle(StyleType.MESSAGE_SPECIAL, 100 - ConfigTombstone.general.getXpLoss() + levelWithBonus * 20);
    }
}

