/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import net.teamfruit.emojicord.Log;
import org.apache.commons.io.IOUtils;

public enum OSUtils {
    LINUX,
    SOLARIS,
    WINDOWS{

        @Override
        protected String[] getOpenCommandLine(URL url) {
            return new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()};
        }
    }
    ,
    OSX{

        @Override
        protected String[] getOpenCommandLine(URL url) {
            return new String[]{"open", url.toString()};
        }
    }
    ,
    UNKNOWN;


    public void openURL(URL url) {
        try {
            Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.getOpenCommandLine(url)));
            for (String s : IOUtils.readLines((InputStream)process.getErrorStream(), (Charset)Charsets.UTF_8)) {
                Log.log.error(s);
            }
            process.getInputStream().close();
            process.getErrorStream().close();
            process.getOutputStream().close();
        }
        catch (IOException | PrivilegedActionException privilegedactionexception) {
            Log.log.error("Couldn't open url '{}'", (Object)url, (Object)privilegedactionexception);
        }
    }

    public void openURI(URI uri) {
        try {
            this.openURL(uri.toURL());
        }
        catch (MalformedURLException malformedurlexception) {
            Log.log.error("Couldn't open uri '{}'", (Object)uri, (Object)malformedurlexception);
        }
    }

    public void openFile(File fileIn) {
        try {
            this.openURL(fileIn.toURI().toURL());
        }
        catch (MalformedURLException malformedurlexception) {
            Log.log.error("Couldn't open file '{}'", (Object)fileIn, (Object)malformedurlexception);
        }
    }

    protected String[] getOpenCommandLine(URL url) {
        String s = url.toString();
        if ("file".equals(url.getProtocol())) {
            s = s.replace("file:", "file://");
        }
        return new String[]{"xdg-open", s};
    }

    public void openURI(String uri) {
        try {
            this.openURL(new URI(uri).toURL());
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException urisyntaxexception) {
            Log.log.error("Couldn't open uri '{}'", (Object)uri, (Object)urisyntaxexception);
        }
    }

    public static OSUtils getOSType() {
        String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (s.contains("win")) {
            return WINDOWS;
        }
        if (s.contains("mac")) {
            return OSX;
        }
        if (s.contains("solaris")) {
            return SOLARIS;
        }
        if (s.contains("sunos")) {
            return SOLARIS;
        }
        if (s.contains("linux")) {
            return LINUX;
        }
        return s.contains("unix") ? LINUX : UNKNOWN;
    }
}

