/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm.lib;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.compat.CompatFMLDeobfuscatingRemapper;
import org.objectweb.asm.tree.ClassNode;

public class ClassMatcher
implements Predicate<ClassNode> {
    @Nonnull
    private final ClassName clsName;
    @Nonnull
    private final String mappedClassName;
    @Nonnull
    private final String unmappedClassName;

    public ClassMatcher(@Nonnull ClassName clsName) {
        this.clsName = clsName;
        this.mappedClassName = this.clsName.getBytecodeName();
        this.unmappedClassName = CompatFMLDeobfuscatingRemapper.unmap(this.mappedClassName);
    }

    public boolean match(@Nonnull String className) {
        return this.unmappedClassName.equals(className) || this.mappedClassName.equals(className);
    }

    @Override
    public boolean test(ClassNode node) {
        return this.match(node.name);
    }

    @Nonnull
    public String toString() {
        return String.format("Class Matcher: %s", this.mappedClassName);
    }
}

