/*
 * Decompiled with CFR 0.152.
 */
package net.elnounch.mc.utils;

import java.util.regex.Pattern;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class VersionSeeker
extends ClassVisitor {
    private String versionFound;
    private static Pattern pattern = Pattern.compile("\\d*\\.\\d*\\.\\d*");

    public VersionSeeker() {
        super(327680);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 1) == 1 && desc.equals("()Ljava/lang/String;")) {
            return new ConstantStringsParser(this);
        }
        return null;
    }

    public static boolean matchVersionPattern(String str) {
        return pattern.matcher(str).matches();
    }

    public String getVersionFound() {
        return this.versionFound;
    }

    public void setVersionFound(String version) {
        this.versionFound = version;
    }

    public void visitEnd() {
        super.visitEnd();
    }

    private class ConstantStringsParser
    extends MethodVisitor {
        VersionSeeker caller;
        int nbInsn;
        String candidate;

        public ConstantStringsParser(VersionSeeker vs) {
            super(327680);
            this.nbInsn = 0;
            this.caller = vs;
        }

        public void visitInsn(int opcode) {
            ++this.nbInsn;
        }

        public void visitLdcInsn(Object cst) {
            String cstString;
            ++this.nbInsn;
            if (cst instanceof String && VersionSeeker.matchVersionPattern(cstString = (String)cst)) {
                this.candidate = cstString;
            }
        }

        public void visitEnd() {
            if (this.nbInsn == 2 && this.candidate != null) {
                this.caller.setVersionFound(this.candidate);
            }
        }
    }
}

