/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.armor;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.armor.IProtectiveArmor;
import zmaster587.advancedRocketry.api.capability.CapabilitySpaceArmor;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.client.render.armor.RenderJetPack;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.api.IJetPack;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.IconResource;

public class ItemSpaceArmor
extends ItemArmor
implements ISpecialArmor,
ICapabilityProvider,
IProtectiveArmor,
IModularArmor {
    private static final String componentNBTName = "componentName";
    private int numModules;

    public ItemSpaceArmor(ItemArmor.ArmorMaterial material, EntityEquipmentSlot component, int numModules) {
        super(material, 0, component);
        this.numModules = numModules;
    }

    public boolean canBeExternallyModified(ItemStack armor, int slot) {
        return true;
    }

    public void func_77624_a(ItemStack stack, World p_77624_2_, List list, ITooltipFlag p_77624_4_) {
        super.func_77624_a(stack, p_77624_2_, list, p_77624_4_);
        list.add(LibVulpes.proxy.getLocalizedString("msg.modules"));
        for (ItemStack componentStack : this.getComponents(stack)) {
            list.add(ChatFormatting.DARK_GRAY + componentStack.func_82833_r());
        }
    }

    public boolean func_77645_m() {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (armorSlot == EntityEquipmentSlot.CHEST) {
            for (ItemStack stack : this.getComponents(itemStack)) {
                if (!(stack.func_77973_b() instanceof IJetPack)) continue;
                return new RenderJetPack(_default);
            }
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return 0xFFFFFF;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (!source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 1);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    private EmbeddedInventory loadEmbeddedInventory(ItemStack stack) {
        if (stack.func_77942_o()) {
            EmbeddedInventory inv = new EmbeddedInventory(this.numModules);
            inv.readFromNBT(stack.func_77978_p());
            return inv;
        }
        return new EmbeddedInventory(this.numModules);
    }

    protected void saveEmbeddedInventory(ItemStack stack, EmbeddedInventory inv) {
        if (stack.func_77942_o()) {
            inv.writeToNBT(stack.func_77978_p());
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            inv.writeToNBT(nbt);
            stack.func_77982_d(nbt);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        super.onArmorTick(world, player, armor);
        if (armor.func_77942_o()) {
            EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                IArmorComponent component = (IArmorComponent)stack.func_77973_b();
                component.onTick(world, player, armor, (IInventory)inv, stack);
            }
            this.saveEmbeddedInventory(armor, inv);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (type != null) {
            if (stack.func_77973_b() == AdvancedRocketryItems.itemSpaceSuit_Leggings) {
                return "advancedRocketry:textures/armor/spaceSuit_layer1_overlay.png";
            }
            return "advancedRocketry:textures/armor/spaceSuit_layer2_overlay.png";
        }
        if (stack.func_77973_b() == AdvancedRocketryItems.itemSpaceSuit_Leggings) {
            return "advancedRocketry:textures/armor/spaceSuit_layer1.png";
        }
        return "advancedRocketry:textures/armor/spaceSuit_layer2.png";
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 1;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        if (armor.func_77942_o()) {
            EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                IArmorComponent component = (IArmorComponent)stack.func_77973_b();
                component.onArmorDamaged(entity, armor, stack, source, damage);
            }
            this.saveEmbeddedInventory(armor, inv);
        }
    }

    public void addArmorComponent(World world, ItemStack armor, ItemStack component, int slot) {
        EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
        if (((IArmorComponent)component.func_77973_b()).onComponentAdded(world, armor)) {
            inv.func_70299_a(slot, component);
            this.saveEmbeddedInventory(armor, inv);
        }
    }

    public ItemStack removeComponent(World world, ItemStack armor, int index) {
        if (!armor.func_77942_o()) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound nbt = armor.func_77978_p();
        NBTTagList componentList = nbt.func_150295_c(componentNBTName, 10);
        EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
        ItemStack stack = inv.func_70301_a(index);
        inv.func_70299_a(index, ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            IArmorComponent component = (IArmorComponent)stack.func_77973_b();
            component.onComponentRemoved(world, armor);
            this.saveEmbeddedInventory(armor, inv);
        }
        return stack;
    }

    public List<ItemStack> getComponents(ItemStack armor) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        if (armor.func_77942_o()) {
            EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i).func_190926_b()) continue;
                list.add(inv.func_70301_a(i));
            }
        }
        return list;
    }

    @Override
    public boolean protectsFromSubstance(IAtmosphere atmosphere, ItemStack stack, boolean commitProtection) {
        return atmosphere == AtmosphereType.SUPERHIGHPRESSURE || atmosphere == AtmosphereType.HIGHPRESSURE || atmosphere == AtmosphereType.VACUUM || atmosphere == AtmosphereType.VERYHOT || atmosphere == AtmosphereType.SUPERHEATED || atmosphere == AtmosphereType.LOWOXYGEN || atmosphere == AtmosphereType.SUPERHIGHPRESSURENOO2 || atmosphere == AtmosphereType.HIGHPRESSURENOO2 || atmosphere == AtmosphereType.VERYHOTNOO2 || atmosphere == AtmosphereType.SUPERHEATEDNOO2 || atmosphere == AtmosphereType.NOO2;
    }

    public int getNumSlots(ItemStack stack) {
        return this.loadEmbeddedInventory(stack).func_70302_i_();
    }

    public ItemStack getComponentInSlot(ItemStack stack, int slot) {
        return this.loadEmbeddedInventory(stack).func_70301_a(slot);
    }

    public IInventory loadModuleInventory(ItemStack stack) {
        return this.loadEmbeddedInventory(stack);
    }

    public void saveModuleInventory(ItemStack stack, IInventory inv) {
        this.saveEmbeddedInventory(stack, (EmbeddedInventory)inv);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilitySpaceArmor.PROTECTIVEARMOR;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilitySpaceArmor.PROTECTIVEARMOR) {
            return (T)this;
        }
        return null;
    }

    public boolean isItemValidForSlot(ItemStack stack, int slot) {
        return true;
    }

    public IconResource getResourceForSlot(int slot) {
        return null;
    }
}

