/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.tasks;

import betterquesting.ScoreboardBQ;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.questing.tasks.TaskScoreboard;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public class PanelTaskScoreboard
extends CanvasMinimum {
    private final IGuiRect initialRect;
    private final TaskScoreboard task;

    public PanelTaskScoreboard(IGuiRect rect, TaskScoreboard task) {
        super(rect);
        this.initialRect = rect;
        this.task = task;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        int width = this.initialRect.getWidth();
        int score = ScoreboardBQ.INSTANCE.getScore(QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g), this.task.scoreName);
        DecimalFormat df = new DecimalFormat("0.##");
        String value = df.format((float)score / this.task.conversion) + this.task.suffix;
        value = this.task.operation.checkValues(score, this.task.target) ? TextFormatting.GREEN + value : TextFormatting.RED + value;
        String txt2 = TextFormatting.BOLD + value + " " + TextFormatting.RESET + this.task.operation.GetText() + " " + df.format((float)this.task.target / this.task.conversion) + this.task.suffix;
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_LEFT, 0, 0, width, 16, 0), this.task.scoreDisp).setAlignment(1).setColor(PresetColor.TEXT_MAIN.getColor()));
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_LEFT, 0, 16, width, 16, 0), txt2).setAlignment(1).setColor(PresetColor.TEXT_MAIN.getColor()));
        this.recalculateSizes();
    }
}

