/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.utils.BigItemStack;
import betterquesting.client.gui2.GuiLootChest;
import betterquesting.core.BetterQuesting;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetLootClaim {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:loot_claim");

    public static void registerHandler() {
        if (BetterQuesting.proxy.isClient()) {
            QuestingAPI.getAPI(ApiReference.PACKET_REG).registerClientHandler(ID_NAME, NetLootClaim::onClient);
        }
    }

    public static void sendReward(@Nonnull EntityPlayerMP player, @Nonnull String title, BigItemStack ... items) {
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (BigItemStack stack : items) {
            list.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        payload.func_74782_a("rewards", (NBTBase)list);
        payload.func_74778_a("title", title);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound data) {
        String title = data.func_74779_i("title");
        ArrayList<BigItemStack> rewards = new ArrayList<BigItemStack>();
        NBTTagList list = data.func_150295_c("rewards", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            rewards.add(new BigItemStack(list.func_150305_b(i)));
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiLootChest(null, rewards, title));
    }
}

