/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.client.gui.GuiDeepLearnerOverlay;
import mustapelto.deepmoblearning.client.gui.GuiTrialOverlay;
import mustapelto.deepmoblearning.client.particles.ParticleGlitch;
import mustapelto.deepmoblearning.client.particles.ParticleScalableSmoke;
import mustapelto.deepmoblearning.client.renders.RenderEntityGlitch;
import mustapelto.deepmoblearning.client.renders.RenderEntityGlitchOrb;
import mustapelto.deepmoblearning.client.renders.TESRTrialKeystone;
import mustapelto.deepmoblearning.common.ServerProxy;
import mustapelto.deepmoblearning.common.capability.CapabilityPlayerTrialProvider;
import mustapelto.deepmoblearning.common.capability.ICapabilityPlayerTrial;
import mustapelto.deepmoblearning.common.entities.EntityGlitch;
import mustapelto.deepmoblearning.common.entities.EntityGlitchOrb;
import mustapelto.deepmoblearning.common.entities.EntityTrialCaveSpider;
import mustapelto.deepmoblearning.common.entities.EntityTrialEnderman;
import mustapelto.deepmoblearning.common.entities.EntityTrialSlime;
import mustapelto.deepmoblearning.common.entities.EntityTrialSpider;
import mustapelto.deepmoblearning.common.tiles.TileEntityTrialKeystone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.RenderCaveSpider;
import net.minecraft.client.renderer.entity.RenderEnderman;
import net.minecraft.client.renderer.entity.RenderSlime;
import net.minecraft.client.renderer.entity.RenderSpider;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends ServerProxy {
    @Override
    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGlitch.class, RenderEntityGlitch::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityGlitchOrb.class, RenderEntityGlitchOrb::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrialEnderman.class, RenderEnderman::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrialSpider.class, RenderSpider::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrialCaveSpider.class, RenderCaveSpider::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrialSlime.class, RenderSlime::new);
    }

    @Override
    public void registerGuiRenderers() {
        MinecraftForge.EVENT_BUS.register((Object)GuiDeepLearnerOverlay.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)GuiTrialOverlay.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrialKeystone.class, (TileEntitySpecialRenderer)new TESRTrialKeystone());
    }

    @Override
    public void spawnSmokeParticle(World world, double x, double y, double z, double mx, double my, double mz, ServerProxy.SmokeType type) {
        float scale = 1.0f;
        switch (type) {
            case CYAN: 
            case MIXED: {
                scale = 1.4f;
                break;
            }
            case SMOKE: {
                scale = 1.6f;
            }
        }
        ParticleScalableSmoke particle = new ParticleScalableSmoke(world, x, y, z, mx, my, mz, scale);
        switch (type) {
            case CYAN: {
                this.setColorCyan((Particle)particle);
                break;
            }
            case MIXED: {
                this.setColorMixed((Particle)particle);
                break;
            }
            case SMOKE: {
                this.setColorSmoke((Particle)particle);
            }
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    public void spawnGlitchParticle(World world, double x, double y, double z, double mx, double my, double mz) {
        ParticleGlitch particle = new ParticleGlitch(world, x, y, z, mx, my, mz);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    private void setColorMixed(Particle particle) {
        boolean spawnCyan;
        boolean bl = spawnCyan = ThreadLocalRandom.current().nextInt(0, 3) == 0;
        if (spawnCyan) {
            this.setColorCyan(particle);
        } else {
            this.setColorGray(particle);
        }
    }

    private void setColorSmoke(Particle particle) {
        boolean spawnBlack;
        boolean spawnRed = ThreadLocalRandom.current().nextInt(0, 3) == 0;
        boolean bl = spawnBlack = ThreadLocalRandom.current().nextInt(0, 4) == 0;
        if (spawnBlack) {
            particle.func_70538_b(0.02f, 0.02f, 0.02f);
        } else if (spawnRed) {
            particle.func_70538_b(0.29f, 0.05f, 0.01f);
        } else {
            this.setColorGray(particle);
        }
    }

    private void setColorCyan(Particle particle) {
        particle.func_70538_b(0.0f, 1.0f, 0.75f);
    }

    private void setColorGray(Particle particle) {
        particle.func_70538_b(0.09f, 0.09f, 0.09f);
    }

    @Override
    public String getLocalizedString(String key, Object ... args) {
        return I18n.func_135052_a((String)key, (Object[])args);
    }

    @Override
    @Nullable
    public ICapabilityPlayerTrial getClientPlayerTrialCapability() {
        return (ICapabilityPlayerTrial)FMLClientHandler.instance().getClientPlayerEntity().getCapability(CapabilityPlayerTrialProvider.PLAYER_TRIAL_CAP, null);
    }
}

