/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.gui;

import com.google.common.collect.ImmutableList;
import mustapelto.deepmoblearning.common.DMLConfig;
import mustapelto.deepmoblearning.common.items.ItemDeepLearner;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.PlayerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiDeepLearnerOverlay
extends GuiScreen {
    public static GuiDeepLearnerOverlay INSTANCE = new GuiDeepLearnerOverlay();
    private static final ResourceLocation TEXTURE = new ResourceLocation("deepmoblearning", "textures/gui/deep_learner_overlay.png");
    private static final int COMPONENT_HEIGHT = 26;
    private static final int DATA_MODEL_WIDTH = 18;
    private static final int EXP_BAR_MAX_WIDTH = 89;
    private static final int EXP_BAR_INNER_HEIGHT = 11;
    private static final int EXP_BAR_OUTER_HEIGHT = 12;
    private static final int PADDING_BASE_HORIZONTAL = 5;
    private static final int PADDING_BASE_VERTICAL = 5;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final FontRenderer fontRenderer;

    private GuiDeepLearnerOverlay() {
        this.fontRenderer = this.mc.field_71466_p;
        this.field_146296_j = this.mc.func_175599_af();
        this.func_183500_a(89, 12);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        int y;
        int x;
        if (!this.mc.field_71415_G || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        ItemStack deepLearner = PlayerHelper.getHeldDeepLearner((EntityPlayer)player);
        if (deepLearner.func_190926_b()) {
            return;
        }
        ImmutableList<ItemStack> dataModels = DataModelHelper.getDataModelStacksFromList(ItemDeepLearner.getContainedItems(deepLearner));
        int paddingHorizontal = DMLConfig.DEEP_LEARNER_GUI_OVERLAY_SETTINGS.PADDING_HORIZONTAL;
        int paddingVertical = DMLConfig.DEEP_LEARNER_GUI_OVERLAY_SETTINGS.PADDING_VERTICAL;
        DMLConfig.DeepLearnerGuiOverlaySettings.GuiPosition position = DMLConfig.DEEP_LEARNER_GUI_OVERLAY_SETTINGS.getGuiPosition();
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        int numberOfBars = dataModels.size();
        switch (position) {
            default: {
                x = 5 + paddingHorizontal;
                y = 5 + paddingVertical;
                break;
            }
            case TOP_RIGHT: {
                x = scaledResolution.func_78326_a() - this.field_146294_l - 5 - paddingHorizontal;
                y = 5 + paddingVertical;
                break;
            }
            case BOTTOM_RIGHT: {
                x = scaledResolution.func_78326_a() - this.field_146294_l - 5 - paddingHorizontal;
                y = scaledResolution.func_78328_b() - numberOfBars * 26 - 5 - paddingVertical;
                break;
            }
            case BOTTOM_LEFT: {
                x = 5 + paddingHorizontal;
                y = scaledResolution.func_78328_b() - numberOfBars * 26 - 5 - paddingVertical;
            }
        }
        for (int i = 0; i < dataModels.size(); ++i) {
            ItemStack dataModel = (ItemStack)dataModels.get(i);
            this.drawExperienceBar(x, y, i, dataModel);
        }
    }

    private void drawExperienceBar(int x, int y, int index, ItemStack dataModel) {
        this.drawItemStack(x, y - 2 + 12 + index * 26, dataModel);
        this.func_73731_b(this.fontRenderer, dataModel.func_82833_r(), x + 4, y + index * 26 + 2, 0xFFFFFF);
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(x + 18, y + 12 + index * 26, 0, 0, 89, 12);
        if (DataModelHelper.isMaxTier(dataModel)) {
            this.func_73729_b(x + 18 + 1, y + 1 + 12 + index * 26, 0, 12, 89, 11);
        } else {
            int dataCurrent = DataModelHelper.getCurrentTierDataCount(dataModel);
            int dataRequired = DataModelHelper.getTierRequiredData(dataModel);
            int killsRequired = DataModelHelper.getKillsToNextTier(dataModel);
            int barWidth = (int)((float)dataCurrent / (float)dataRequired * 89.0f);
            this.func_73729_b(x + 18 + 1, y + 1 + 12 + index * 26, 0, 12, barWidth, 11);
            this.func_73731_b(this.fontRenderer, I18n.func_135052_a((String)"deepmoblearning.data_overlay.kills_needed", (Object[])new Object[]{killsRequired}), x + 18 + 3, y + 2 + 12 + index * 26, 0xFFFFFF);
        }
    }

    private void drawItemStack(int x, int y, ItemStack stack) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }
}

