/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.client.gui.GuiMachine;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonBase;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonItemDeselect;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonItemSelect;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonPageSelect;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.tiles.TileEntityLootFabricator;
import mustapelto.deepmoblearning.common.util.MathHelper;
import mustapelto.deepmoblearning.common.util.Point;
import mustapelto.deepmoblearning.common.util.Rect;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GuiLootFabricator
extends GuiMachine {
    private static final ResourceLocation TEXTURE = new ResourceLocation("deepmoblearning", "textures/gui/loot_fabricator.png");
    private static final int WIDTH = 177;
    private static final int HEIGHT = 230;
    private static final Rect MAIN_GUI = new Rect(0, 0, 177, 83);
    private static final Point REDSTONE_BUTTON = new Point(-20, 0);
    private static final Point OUTPUT_SELECT_LIST = new Point(14, 6);
    private static final int OUTPUT_SELECT_LIST_PADDING = 2;
    private static final int OUTPUT_SELECT_LIST_GUTTER = 1;
    private static final int OUTPUT_SELECT_BUTTON_SIZE = 18;
    private static final Point PREV_PAGE_BUTTON = new Point(13, 66);
    private static final Point NEXT_PAGE_BUTTON = new Point(44, 66);
    private static final Point DESELECT_BUTTON = new Point(79, 4);
    private static final int ITEMS_PER_PAGE = 9;
    private static final int PREV_PAGE_BUTTON_ID = 10;
    private static final int NEXT_PAGE_BUTTON_ID = 11;
    private static final int DESELECT_BUTTON_ID = 12;
    private static final int ITEM_SELECT_BUTTON_ID_OFFSET = 20;
    private static final Rect ENERGY_BAR = new Rect(4, 6, 7, 71);
    private static final Rect PROGRESS_BAR = new Rect(84, 22, 6, 36);
    private static final long ERROR_BAR_CYCLE = 20L;
    private final TileEntityLootFabricator lootFabricator;
    @Nullable
    private MetadataDataModel pristineMatterMetadata;
    private ImmutableList<ItemStack> lootItemList;
    private int currentOutputItemPage = -1;
    private int totalOutputItemPages = 0;
    private ItemStack outputItem = ItemStack.field_190927_a;
    private final List<ButtonItemSelect> outputSelectButtons = new ArrayList<ButtonItemSelect>();
    private ButtonPageSelect nextPageButton;
    private ButtonPageSelect prevPageButton;
    private ButtonItemDeselect deselectButton;
    private CraftingError craftingError = CraftingError.NONE;

    public GuiLootFabricator(TileEntityLootFabricator tileEntity, EntityPlayer player, World world) {
        super(tileEntity, player, world, 177, 230, REDSTONE_BUTTON);
        this.lootFabricator = tileEntity;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.pristineMatterMetadata = this.lootFabricator.getPristineMatterMetadata();
        this.resetOutputData();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        MetadataDataModel lootFabMetadata = this.lootFabricator.getPristineMatterMetadata();
        if (this.pristineMatterMetadata != lootFabMetadata) {
            this.pristineMatterMetadata = lootFabMetadata;
            this.resetOutputData();
        }
        this.craftingError = !this.lootFabricator.isRedstoneActive() ? CraftingError.REDSTONE : (!this.lootFabricator.hasPristineMatter() ? CraftingError.NO_PRISTINE : (this.outputItem == ItemStack.field_190927_a ? CraftingError.NO_OUTPUT_SELECTED : (!this.lootFabricator.hasRoomForOutput() ? CraftingError.OUTPUT_FULL : (!this.lootFabricator.hasEnergyForCrafting() ? CraftingError.NO_ENERGY : CraftingError.NONE))));
    }

    private void resetOutputData() {
        this.outputItem = this.lootFabricator.getOutputItem();
        this.deselectButton.setDisplayStack(this.outputItem);
        if (this.pristineMatterMetadata == null) {
            this.lootItemList = ImmutableList.of();
            this.currentOutputItemPage = -1;
            this.totalOutputItemPages = 0;
            this.setPageButtonsEnabled(false);
        } else {
            this.lootItemList = this.pristineMatterMetadata.getLootItems();
            if (!this.outputItem.func_190926_b()) {
                int currentOutputItemIndex = this.pristineMatterMetadata.getLootItemIndex(this.outputItem);
                this.currentOutputItemPage = currentOutputItemIndex / 9;
            } else {
                this.currentOutputItemPage = 0;
            }
            this.totalOutputItemPages = MathHelper.divideAndRoundUp(this.lootItemList.size(), 9);
            this.setPageButtonsEnabled(this.totalOutputItemPages > 1);
        }
        this.rebuildOutputSelectButtons();
    }

    private void rebuildOutputSelectButtons() {
        this.outputSelectButtons.clear();
        this.constructOutputSelectButtonRows();
        this.buttonListNeedsRebuild = true;
    }

    private void constructOutputSelectButtonRows() {
        if (this.currentOutputItemPage < 0) {
            return;
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int indexRelative = row * 3 + col;
                int indexAbsolute = this.currentOutputItemPage * 9 + indexRelative;
                if (indexAbsolute >= this.lootItemList.size()) {
                    return;
                }
                ItemStack stack = (ItemStack)this.lootItemList.get(indexAbsolute);
                this.outputSelectButtons.add(new ButtonItemSelect(20 + indexRelative, this.field_147003_i + GuiLootFabricator.OUTPUT_SELECT_LIST.X + 2 + col * 19, this.field_147009_r + GuiLootFabricator.OUTPUT_SELECT_LIST.Y + 2 + row * 19, stack, indexAbsolute, ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.outputItem)));
            }
        }
    }

    private void setOutputItem(int index) {
        for (int i = 0; i < this.outputSelectButtons.size(); ++i) {
            this.outputSelectButtons.get(i).setSelected(index != -1 && i == index % 9);
        }
        this.outputItem = index < 0 || index >= this.lootItemList.size() ? ItemStack.field_190927_a : (ItemStack)this.lootItemList.get(index);
        this.deselectButton.setDisplayStack(this.outputItem);
        this.lootFabricator.setOutputItem(this.outputItem);
    }

    @Override
    protected void initButtons() {
        super.initButtons();
        this.prevPageButton = new ButtonPageSelect(10, this.field_147003_i + GuiLootFabricator.PREV_PAGE_BUTTON.X, this.field_147009_r + GuiLootFabricator.PREV_PAGE_BUTTON.Y, ButtonPageSelect.Direction.PREV);
        this.nextPageButton = new ButtonPageSelect(11, this.field_147003_i + GuiLootFabricator.NEXT_PAGE_BUTTON.X, this.field_147009_r + GuiLootFabricator.NEXT_PAGE_BUTTON.Y, ButtonPageSelect.Direction.NEXT);
        this.deselectButton = new ButtonItemDeselect(12, this.field_147003_i + GuiLootFabricator.DESELECT_BUTTON.X, this.field_147009_r + GuiLootFabricator.DESELECT_BUTTON.Y);
    }

    @Override
    protected void rebuildButtonList() {
        super.rebuildButtonList();
        this.field_146292_n.add(this.prevPageButton);
        this.field_146292_n.add(this.nextPageButton);
        this.field_146292_n.add(this.deselectButton);
        this.field_146292_n.addAll(this.outputSelectButtons);
    }

    @Override
    protected void handleButtonPress(ButtonBase button, int mouseButton) {
        if (mouseButton == 0 && button instanceof ButtonPageSelect) {
            ButtonPageSelect pageSelectButton = (ButtonPageSelect)button;
            if (pageSelectButton.getDirection() == ButtonPageSelect.Direction.PREV) {
                --this.currentOutputItemPage;
                if (this.currentOutputItemPage < 0) {
                    this.currentOutputItemPage = this.totalOutputItemPages - 1;
                }
            } else {
                ++this.currentOutputItemPage;
                if (this.currentOutputItemPage >= this.totalOutputItemPages) {
                    this.currentOutputItemPage = 0;
                }
            }
            this.rebuildOutputSelectButtons();
        } else if (mouseButton == 0 && button instanceof ButtonItemSelect) {
            ButtonItemSelect itemSelectButton = (ButtonItemSelect)button;
            this.setOutputItem(itemSelectButton.getIndex());
        } else if (mouseButton == 0 && button instanceof ButtonItemDeselect) {
            this.setOutputItem(-1);
        } else {
            super.handleButtonPress(button, mouseButton);
        }
    }

    private void setPageButtonsEnabled(boolean enabled) {
        this.prevPageButton.field_146124_l = enabled;
        this.nextPageButton.field_146124_l = enabled;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        RenderHelper.func_74520_c();
        this.outputSelectButtons.forEach(button -> this.drawItemStackWithOverlay(button.getStack(), button.field_146128_h - this.field_147003_i, button.field_146129_i - this.field_147009_r));
        ItemStack deselectStack = this.deselectButton.getDisplayStack();
        if (!deselectStack.func_190926_b()) {
            this.drawItemStackWithOverlay(deselectStack, GuiLootFabricator.DESELECT_BUTTON.X, GuiLootFabricator.DESELECT_BUTTON.Y);
        }
        RenderHelper.func_74518_a();
        super.func_146979_b(mouseX, mouseY);
        int mouseRelativeX = mouseX - this.field_147003_i;
        int mouseRelativeY = mouseY - this.field_147009_r;
        if (ENERGY_BAR.isInside(mouseRelativeX, mouseRelativeY)) {
            String currentEnergy = String.valueOf(this.tileEntity.getEnergy());
            String maxEnergy = String.valueOf(this.tileEntity.getMaxEnergy());
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(currentEnergy + "/" + maxEnergy + " RF");
            tooltip.add(I18n.func_135052_a((String)"deepmoblearning.loot_fabricator.tooltip.crafting_cost", (Object[])new Object[]{this.tileEntity.getCraftingEnergyCost()}));
            this.func_146283_a(tooltip, mouseRelativeX, mouseRelativeY);
        }
        if (this.craftingError != CraftingError.NONE && PROGRESS_BAR.isInside(mouseRelativeX, mouseRelativeY)) {
            String tooltip = "";
            switch (this.craftingError) {
                case NO_ENERGY: {
                    tooltip = I18n.func_135052_a((String)"deepmoblearning.loot_fabricator.error.no_energy", (Object[])new Object[0]);
                    break;
                }
                case REDSTONE: {
                    tooltip = I18n.func_135052_a((String)"deepmoblearning.loot_fabricator.error.redstone", (Object[])new Object[0]);
                    break;
                }
                case NO_PRISTINE: {
                    tooltip = I18n.func_135052_a((String)"deepmoblearning.loot_fabricator.error.no_pristine", (Object[])new Object[0]);
                    break;
                }
                case NO_OUTPUT_SELECTED: {
                    tooltip = I18n.func_135052_a((String)"deepmoblearning.loot_fabricator.error.no_output_selected", (Object[])new Object[0]);
                    break;
                }
                case OUTPUT_FULL: {
                    tooltip = I18n.func_135052_a((String)"deepmoblearning.loot_fabricator.error.output_full", (Object[])new Object[0]);
                }
            }
            this.func_146279_a(tooltip, mouseRelativeX, mouseRelativeY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.textureManager.func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i + GuiLootFabricator.MAIN_GUI.LEFT, this.field_147009_r + GuiLootFabricator.MAIN_GUI.TOP, TextureCoords.MAIN_GUI.X, TextureCoords.MAIN_GUI.Y, GuiLootFabricator.MAIN_GUI.WIDTH, GuiLootFabricator.MAIN_GUI.HEIGHT);
        int progressBarHeight = (int)(this.tileEntity.getRelativeCraftingProgress() * (float)GuiLootFabricator.PROGRESS_BAR.HEIGHT);
        int progressBarOffset = GuiLootFabricator.PROGRESS_BAR.HEIGHT - progressBarHeight;
        this.func_73729_b(this.field_147003_i + GuiLootFabricator.PROGRESS_BAR.LEFT, this.field_147009_r + GuiLootFabricator.PROGRESS_BAR.TOP + progressBarOffset, TextureCoords.PROGRESS_BAR.X, TextureCoords.PROGRESS_BAR.Y, GuiLootFabricator.PROGRESS_BAR.WIDTH, progressBarHeight);
        if (this.craftingError != CraftingError.NONE && (long)this.currentTick % 20L < 10L) {
            this.func_73729_b(this.field_147003_i + GuiLootFabricator.PROGRESS_BAR.LEFT, this.field_147009_r + GuiLootFabricator.PROGRESS_BAR.TOP + 1, TextureCoords.ERROR_BAR.X, TextureCoords.ERROR_BAR.Y, GuiLootFabricator.PROGRESS_BAR.WIDTH, GuiLootFabricator.PROGRESS_BAR.HEIGHT);
        }
        this.drawEnergyBar(ENERGY_BAR, TextureCoords.ENERGY_BAR);
        this.drawPlayerInventory(this.field_147003_i + DMLConstants.Gui.LootFabricator.PLAYER_INVENTORY.X, this.field_147009_r + DMLConstants.Gui.LootFabricator.PLAYER_INVENTORY.Y);
    }

    private static enum CraftingError {
        NONE,
        NO_ENERGY,
        REDSTONE,
        NO_PRISTINE,
        NO_OUTPUT_SELECTED,
        OUTPUT_FULL;

    }

    private static final class TextureCoords {
        private static final Point MAIN_GUI = new Point(0, 0);
        private static final Point ENERGY_BAR = new Point(0, 83);
        private static final Point PROGRESS_BAR = new Point(7, 83);
        private static final Point ERROR_BAR = new Point(13, 83);

        private TextureCoords() {
        }
    }
}

