/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.jei.simulation;

import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mustapelto.deepmoblearning.client.jei.simulation.SimulationChamberRecipe;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class SimulationChamberWrapper
implements IRecipeWrapper {
    private long ticks = 0L;
    private long lastWorldTime;
    private final ItemStack dataModel;
    private final NonNullList<ItemStack> inputs;
    private final NonNullList<ItemStack> outputs;

    public SimulationChamberWrapper(SimulationChamberRecipe recipe) {
        this.dataModel = recipe.dataModel;
        this.inputs = NonNullList.func_191196_a();
        this.inputs.add((Object)this.dataModel);
        this.inputs.add((Object)recipe.input);
        this.outputs = NonNullList.func_191196_a();
        this.outputs.add((Object)recipe.livingOutput);
        this.outputs.add((Object)recipe.pristineOutput);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.renderPristineChance(minecraft);
        if (this.lastWorldTime == minecraft.field_71441_e.func_82737_E()) {
            return;
        }
        ++this.ticks;
        this.lastWorldTime = minecraft.field_71441_e.func_82737_E();
        if (this.ticks % 30L == 0L) {
            this.cycleTier();
        }
    }

    private void cycleTier() {
        if (DataModelHelper.isMaxTier(this.dataModel)) {
            DataModelHelper.setTierLevel(this.dataModel, 1);
        } else {
            DataModelHelper.setTierLevel(this.dataModel, DataModelHelper.getTier(this.dataModel) + 1);
        }
    }

    private void renderPristineChance(@Nonnull Minecraft minecraft) {
        FontRenderer render = minecraft.field_71466_p;
        String tierName = DataModelHelper.getTierDisplayNameFormatted(this.dataModel);
        render.func_175063_a(tierName, (float)(70 - render.func_78256_a(tierName)), 30.0f, 0xFFFFFF);
        int pristineChance = DataModelHelper.getPristineChance(this.dataModel);
        String chanceText = pristineChance + "%";
        render.func_175063_a(chanceText, 97.0f, 31.0f, 0xFFFFFF);
    }
}

