/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.inventory;

import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.common.inventory.ContainerBase;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerDataModel;
import mustapelto.deepmoblearning.common.inventory.SlotDataModel;
import mustapelto.deepmoblearning.common.items.ItemDeepLearner;
import mustapelto.deepmoblearning.common.util.PlayerHelper;
import mustapelto.deepmoblearning.common.util.Point;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerDeepLearner
extends ContainerBase {
    public static final int INTERNAL_SLOTS = DMLConstants.Gui.DeepLearner.DATA_MODEL_SLOTS.size();
    private final ItemHandlerDataModel itemHandler;
    private final int deepLearnerSlotIndex;
    private final ItemStack deepLearner;

    public ContainerDeepLearner(EntityPlayer player) {
        this.deepLearner = PlayerHelper.getHeldDeepLearner(player);
        if (this.deepLearner.func_190926_b()) {
            throw new IllegalArgumentException("Tried to open Deep Learner GUI without Deep Learner equipped");
        }
        this.itemHandler = new ItemHandlerDataModel(ItemDeepLearner.getContainedItems(this.deepLearner));
        int dlSlot = ((ItemDeepLearner)this.deepLearner.func_77973_b()).getInventorySlot();
        this.deepLearnerSlotIndex = dlSlot >= 0 ? dlSlot + INTERNAL_SLOTS : dlSlot;
        this.addDataModelSlots();
        this.addInventorySlots(player.field_71071_by, DMLConstants.Gui.DeepLearner.PLAYER_INVENTORY.X, DMLConstants.Gui.DeepLearner.PLAYER_INVENTORY.Y);
    }

    private void addDataModelSlots() {
        for (int i = 0; i < INTERNAL_SLOTS; ++i) {
            Point coords = (Point)DMLConstants.Gui.DeepLearner.DATA_MODEL_SLOTS.get(i);
            this.func_75146_a((Slot)new SlotDataModel((IItemHandler)this.itemHandler, i, coords.X, coords.Y));
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack result = super.func_82846_b(playerIn, index);
        ItemDeepLearner.setContainedItems(this.deepLearner, this.itemHandler.getItemStacks());
        playerIn.field_71071_by.func_70296_d();
        return result;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (this.deepLearnerSlotIndex != -1 && slotId == this.deepLearnerSlotIndex || clickTypeIn == ClickType.SWAP && dragType == player.field_71071_by.field_70461_c) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        ItemDeepLearner.setContainedItems(this.deepLearner, this.itemHandler.getItemStacks());
        return stack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        ItemDeepLearner.setContainedItems(this.deepLearner, this.itemHandler.getItemStacks());
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return !playerIn.func_175149_v();
    }
}

