/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.metadata;

import com.google.gson.JsonObject;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.metadata.Metadata;
import mustapelto.deepmoblearning.common.util.StringHelper;
import net.minecraft.util.text.TextFormatting;

public class MetadataDataModelTier
extends Metadata {
    private static final String TIER = "tier";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DISPLAY_COLOR = "displayColor";
    private static final String KILL_MULTIPLIER = "killMultiplier";
    private static final String DATA_TO_NEXT = "dataToNext";
    private static final String PRISTINE_CHANCE = "pristineChance";
    private static final String CAN_SIMULATE = "canSimulate";
    private static final String TRIAL = "trial";
    private static final String[] REQUIRED_KEYS = new String[]{"tier"};
    private static final int DEFAULT_TIER = -1;
    private static final String DEFAULT_DISPLAY_NAME = "Tier %s";
    private static final String DEFAULT_DISPLAY_COLOR = "white";
    private static final int DEFAULT_KILL_MULTIPLIER = 1;
    private static final int DEFAULT_DATA_TO_NEXT = 10;
    private static final int DEFAULT_PRISTINE_CHANCE = 10;
    private static final boolean DEFAULT_CAN_SIMULATE = true;
    private final int tier;
    private final String displayName;
    private final int killMultiplier;
    private final int dataToNext;
    private final int pristineChance;
    private final boolean canSimulate;
    private final TierTrialData tierTrialData;
    private final TextFormatting displayColor;
    private final String displayNameFormatted;

    public MetadataDataModelTier(JsonObject data) throws IllegalArgumentException {
        if (MetadataDataModelTier.isInvalidJson(data, REQUIRED_KEYS)) {
            throw new IllegalArgumentException("Invalid Data Model Tier JSON entry!");
        }
        this.tier = MetadataDataModelTier.getInt(data, TIER, 0, 100).orElse(-1);
        this.displayName = MetadataDataModelTier.getString(data, DISPLAY_NAME).orElse(String.format(DEFAULT_DISPLAY_NAME, this.tier));
        String displayColorString = MetadataDataModelTier.getString(data, DISPLAY_COLOR).orElse(DEFAULT_DISPLAY_COLOR);
        this.displayColor = StringHelper.getValidFormatting(displayColorString);
        this.displayNameFormatted = StringHelper.getFormattedString(this.displayName, this.displayColor);
        this.killMultiplier = MetadataDataModelTier.getInt(data, KILL_MULTIPLIER, 1, 1000).orElse(1);
        this.dataToNext = MetadataDataModelTier.getInt(data, DATA_TO_NEXT, 1, 10000).orElse(10);
        this.pristineChance = MetadataDataModelTier.getInt(data, PRISTINE_CHANCE, 0, 100).orElse(10);
        this.canSimulate = MetadataDataModelTier.getBoolean(data, CAN_SIMULATE).orElse(true);
        JsonObject trialDataJSON = MetadataDataModelTier.getJsonObject(data, TRIAL).orElse(null);
        if (trialDataJSON == null) {
            this.tierTrialData = TierTrialData.DEFAULT;
            DMLRelearned.logger.warn("Invalid Trial entry in Data Model Tier JSON. Using default values.");
        } else {
            this.tierTrialData = new TierTrialData(trialDataJSON);
        }
    }

    @Override
    public void finalizeData() {
    }

    @Override
    public String getID() {
        return String.valueOf(this.tier);
    }

    public int getTier() {
        return this.tier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameFormatted() {
        return this.displayNameFormatted;
    }

    public TextFormatting getDisplayColor() {
        return this.displayColor;
    }

    public int getKillMultiplier() {
        return this.killMultiplier;
    }

    public int getDataToNext() {
        return this.dataToNext;
    }

    public boolean getCanSimulate() {
        return this.canSimulate;
    }

    public int getPristineChance() {
        return this.pristineChance;
    }

    public TierTrialData getTierTrialData() {
        return this.tierTrialData;
    }

    public static class TierTrialData {
        public static final TierTrialData DEFAULT = new TierTrialData();
        private static final int DEFAULT_PRISTINE = 2;
        private static final int DEFAULT_MAX_WAVE = 10;
        private static final int DEFAULT_AFFIXES = 0;
        private static final int DEFAULT_GLITCH_CHANCE = 5;
        private final int pristine;
        private final int maxWave;
        private final int affixes;
        private final int glitchChance;

        private TierTrialData() {
            this.pristine = 2;
            this.maxWave = 10;
            this.affixes = 0;
            this.glitchChance = 5;
        }

        public TierTrialData(JsonObject data) {
            this.pristine = Metadata.getInt(data, "pristine", 0, 64).orElse(2);
            this.maxWave = Metadata.getInt(data, "maxWave", 0, 100).orElse(10);
            this.affixes = Metadata.getInt(data, "affixes", 0, 3).orElse(0);
            this.glitchChance = Metadata.getInt(data, "glitchChance", 0, 100).orElse(5);
        }

        public int getPristine() {
            return this.pristine;
        }

        public int getAffixes() {
            return this.affixes;
        }

        public int getGlitchChance() {
            return this.glitchChance;
        }

        public int getMaxWave() {
            return this.maxWave;
        }
    }
}

