/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.registry.IRenderOverride;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.Teleporter;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.ITeleportEndPoint;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.handlers.DislocatorLinkHandler;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.brandon3055.draconicevolution.network.PacketDislocatorUpdateRequest;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DislocatorBound
extends Dislocator
implements IRenderOverride {
    private ModelResourceLocation modelLocation = new ModelResourceLocation("draconicevolution:dislocator_bound");

    public DislocatorBound() {
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.addName(0, "bound");
        this.addName(1, "p2p");
        this.addName(2, "player");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 1));
            items.add((Object)new ItemStack((Item)this, 1, 2));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity.field_70173_aa % 20 == 0 && !world.field_72995_K && this.isValid(stack) && !this.isPlayer(stack) && entity instanceof EntityPlayer) {
            DislocatorLinkHandler.updateLink(world, stack, (EntityPlayer)entity);
        }
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70292_b % 20 == 0) {
            ItemStack stack = entityItem.func_92059_d();
            if (!entityItem.field_70170_p.field_72995_K && this.isValid(stack) && !this.isPlayer(stack)) {
                DislocatorLinkHandler.updateLink(entityItem.field_70170_p, stack, new BlockPos((Entity)entityItem), entityItem.field_71093_bK);
            }
        }
        return super.onEntityItemUpdate(entityItem);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        Teleporter.TeleportLocation location = this.getLocation(stack, player.field_70170_p);
        if (location == null) {
            if (this.isPlayer(stack)) {
                player.func_145747_a(new TextComponentTranslation("info.de.bound_dislocator.cant_find_player", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            } else {
                player.func_145747_a(new TextComponentTranslation("info.de.bound_dislocator.cant_find_target", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return true;
        }
        if (!entity.func_184222_aU() || !(entity instanceof EntityLiving)) {
            return true;
        }
        DESoundHandler.playSoundFromServer(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
        location.setPitch(player.field_70125_A);
        location.setYaw(player.field_70177_z);
        this.notifyArriving(stack, player.field_70170_p, entity);
        location.teleport(entity);
        DESoundHandler.playSoundFromServer(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
        player.func_145747_a((ITextComponent)new TextComponentString(new TextComponentTranslation("msg.teleporterSentMob.txt", new Object[0]).func_150254_d() + " x:" + (int)location.getXCoord() + " y:" + (int)location.getYCoord() + " z:" + (int)location.getZCoord() + " Dimension: " + location.getDimensionName()));
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.field_70170_p.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77960_j() == 1 && !world.field_72995_K) {
            ItemStack boundA = new ItemStack((Item)DEFeatures.dislocatorBound, 1);
            ItemStack boundB = new ItemStack((Item)DEFeatures.dislocatorBound, 1);
            String uuid = UUID.randomUUID().toString();
            ItemNBTHelper.setString((ItemStack)boundA, (String)"LinkKey", (String)uuid);
            ItemNBTHelper.setString((ItemStack)boundB, (String)"LinkKey", (String)uuid);
            ItemNBTHelper.setByte((ItemStack)boundA, (String)"Side", (byte)0);
            ItemNBTHelper.setByte((ItemStack)boundB, (String)"Side", (byte)1);
            player.func_184611_a(hand, ItemStack.field_190927_a);
            InventoryUtils.givePlayerStack((EntityPlayer)player, (ItemStack)boundA);
            InventoryUtils.givePlayerStack((EntityPlayer)player, (ItemStack)boundB);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (stack.func_77960_j() == 2 && !world.field_72995_K) {
            stack.func_77964_b(0);
            ItemNBTHelper.setString((ItemStack)stack, (String)"PlayerLink", (String)player.func_146103_bH().getId().toString());
            ItemNBTHelper.setString((ItemStack)stack, (String)"PlayerName", (String)player.func_70005_c_());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        Teleporter.TeleportLocation location = this.getLocation(stack, world);
        if (location == null) {
            if (this.isPlayer(stack)) {
                player.func_145747_a(new TextComponentTranslation("info.de.bound_dislocator.cant_find_player", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            } else {
                player.func_145747_a(new TextComponentTranslation("info.de.bound_dislocator.cant_find_target", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        DESoundHandler.playSoundFromServer(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
        location.setPitch(player.field_70125_A);
        location.setYaw(player.field_70177_z);
        this.notifyArriving(stack, player.field_70170_p, (Entity)player);
        location.teleport((Entity)player);
        DESoundHandler.playSoundFromServer(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean isValid(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        return stack.func_77973_b() == DEFeatures.dislocatorBound && compound != null && stack.func_77960_j() == 0 && (compound.func_74764_b("PlayerLink") || compound.func_74764_b("LinkKey") && compound.func_74764_b("Side"));
    }

    public boolean isPlayer(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("PlayerLink");
    }

    public String getLinkID(ItemStack stack) {
        return this.getKey(stack) + "|" + this.getSide(stack);
    }

    public String getPlayerID(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"PlayerLink", (String)"");
    }

    public String getLinkToID(ItemStack stack) {
        return this.getKey(stack) + "|" + (this.getSide(stack) == 0 ? 1 : 0);
    }

    public String getKey(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"LinkKey", (String)"");
    }

    public int getSide(ItemStack stack) {
        return ItemNBTHelper.getByte((ItemStack)stack, (String)"Side", (byte)-1);
    }

    @Override
    public Teleporter.TeleportLocation getLocation(ItemStack stack, World world) {
        DislocatorLinkHandler.LinkData data = DislocatorLinkHandler.getLink(stack, world);
        if (this.isPlayer(stack)) {
            MinecraftServer server = world.func_73046_m();
            if (server == null) {
                return null;
            }
            EntityPlayerMP player = server.func_184103_al().func_177451_a(UUID.fromString(this.getPlayerID(stack)));
            if (player == null) {
                return null;
            }
            return new Teleporter.TeleportLocation(player.field_70165_t, player.field_70163_u + 0.2, player.field_70161_v, player.field_71093_bK);
        }
        Vec3D pos = DislocatorLinkHandler.getLinkPos(world, stack);
        if (data != null && pos != null) {
            return new Teleporter.TeleportLocation(pos.x, pos.y, pos.z, data.dimension);
        }
        return null;
    }

    public void notifyArriving(ItemStack stack, World world, Entity entity) {
        DislocatorLinkHandler.LinkData data = DislocatorLinkHandler.getLink(stack, world);
        if (data != null && this.isValid(stack) && !this.isPlayer(stack)) {
            if (world.func_73046_m() == null || !DimensionManager.isDimensionRegistered((int)data.dimension)) {
                return;
            }
            TileEntity tile = world.func_73046_m().func_71218_a(data.dimension).func_175625_s(data.pos);
            if (tile instanceof ITeleportEndPoint) {
                ((ITeleportEndPoint)tile).entityArriving(entity);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77960_j() == 0) {
            if (!this.isValid(stack)) {
                tooltip.add(TextFormatting.RED + "Error this item is not valid! (Item is missing required NBT data)");
            } else if (this.isPlayer(stack)) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.de.bound_dislocator.player_link", (Object[])new Object[0]) + ": " + ItemNBTHelper.getString((ItemStack)stack, (String)"PlayerName", (String)"Unknown Player"));
            } else {
                if (ClientEventHandler.elapsedTicks % 20 == 0) {
                    DraconicEvolution.network.sendToServer((IMessage)new PacketDislocatorUpdateRequest(this.getLinkToID(stack)));
                }
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.de.bound_dislocator.key", (Object[])new Object[0]) + ": " + ItemNBTHelper.getString((ItemStack)stack, (String)"LinkKey", (String)"Error... No Key") + "|" + ItemNBTHelper.getByte((ItemStack)stack, (String)"Side", (byte)-1));
                DislocatorLinkHandler.LinkData link = DislocatorLinkHandler.getLink(stack, world);
                if (link == null) {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.de.bound_dislocator.bound_to", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"info.de.bound_dislocator.unknown_link", (Object[])new Object[0]));
                } else if (link.isPlayer) {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.de.bound_dislocator.in_player_inventory", (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.de.bound_dislocator.bound_to", (Object[])new Object[0]) + ": " + String.format("[x:%s, y:%s, z:%s, dim:%s]", link.pos.func_177958_n(), link.pos.func_177956_o(), link.pos.func_177952_p(), link.dimension));
                }
            }
        } else if (stack.func_77960_j() == 1) {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"info.de.bound_dislocator.click_to_link", (Object[])new Object[0]));
        } else if (stack.func_77960_j() == 2) {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"info.de.bound_dislocator.click_to_link_self", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Override
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> this.modelLocation);
    }

    public boolean registerNormal(Feature feature) {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

