/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.lang.Lang;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class DarkSteelTooltipManager {
    private static boolean skipUpgradeTooltips = false;

    public static void addCommonTooltipEntries(@Nonnull ItemStack itemstack, EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)itemstack.func_77977_a());
        if (itemstack.func_77973_b() instanceof IDarkSteelItem) {
            for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                if (!(upgrade instanceof IAdvancedTooltipProvider) || !upgrade.hasUpgrade(itemstack, (IDarkSteelItem)itemstack.func_77973_b())) continue;
                ((IAdvancedTooltipProvider)upgrade).addCommonEntries(itemstack, entityplayer, list, flag);
            }
        }
    }

    public static void addBasicTooltipEntries(@Nonnull ItemStack itemstack, EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)itemstack.func_77977_a());
        if (itemstack.func_77973_b() instanceof IDarkSteelItem) {
            for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                if (!(upgrade instanceof IAdvancedTooltipProvider) || !upgrade.hasUpgrade(itemstack, (IDarkSteelItem)itemstack.func_77973_b())) continue;
                ((IAdvancedTooltipProvider)upgrade).addBasicEntries(itemstack, entityplayer, list, flag);
            }
        }
    }

    public static void setSkipUpgradeTooltips(boolean skipUpgradeTooltips) {
        DarkSteelTooltipManager.skipUpgradeTooltips = skipUpgradeTooltips;
    }

    public static void addAdvancedTooltipEntries(@Nonnull ItemStack itemstack, EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)itemstack.func_77977_a());
        if (itemstack.func_77973_b() instanceof IDarkSteelItem && !skipUpgradeTooltips) {
            ArrayList<IDarkSteelUpgrade> applyableUpgrades = new ArrayList<IDarkSteelUpgrade>();
            for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                if (upgrade instanceof IAdvancedTooltipProvider && upgrade.hasUpgrade(itemstack, (IDarkSteelItem)itemstack.func_77973_b())) {
                    ((IAdvancedTooltipProvider)upgrade).addDetailedEntries(itemstack, entityplayer, list, flag);
                    continue;
                }
                if (!upgrade.canAddToItem(itemstack, (IDarkSteelItem)itemstack.func_77973_b())) continue;
                applyableUpgrades.add(upgrade);
            }
            if (!applyableUpgrades.isEmpty()) {
                list.add(TextFormatting.YELLOW + EnderIO.lang.localize("tooltip.anvilupgrades") + " ");
                for (IDarkSteelUpgrade up : applyableUpgrades) {
                    list.add(Lang.DARK_STEEL_LEVELS2.get(TextFormatting.DARK_AQUA, TextFormatting.ITALIC, up.getDisplayName(), 1));
                }
            }
        }
    }
}

