/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.gui.history;

import com.github.vfyjxf.jeiutilities.config.JeiUtilitiesConfig;
import com.github.vfyjxf.jeiutilities.config.SplittingMode;
import com.github.vfyjxf.jeiutilities.helper.IngredientHelper;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import com.github.vfyjxf.jeiutilities.jei.ingredient.RecipeInfo;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.ingredients.IngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.render.IngredientRenderer;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.GiveMode;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.items.ItemHandlerHelper;
import org.lwjgl.opengl.GL11;

public class AdvancedIngredientGrid
extends IngredientGrid {
    public static final int USE_ROWS = 2;
    public static final int MIN_ROWS = 6;
    private int historySize;
    private int columns;
    private final IngredientListBatchRenderer guiHistoryIngredientSlots;
    private final List<IIngredientListElement> historyIngredientElements = new ArrayList<IIngredientListElement>();
    private boolean showHistory;

    public AdvancedIngredientGrid() {
        super(GridAlignment.LEFT);
        this.guiHistoryIngredientSlots = new IngredientListBatchRenderer();
    }

    public boolean updateBounds(@Nonnull Rectangle availableArea, int minWidth, @Nonnull Collection<Rectangle> exclusionAreas) {
        boolean blocked;
        Rectangle stackArea;
        IngredientListSlot ingredientListSlot;
        int x1;
        int column;
        int y1;
        int row;
        int columns;
        this.columns = columns = Math.min(availableArea.width / INGREDIENT_WIDTH, Config.getMaxColumns());
        int rows = availableArea.height / INGREDIENT_HEIGHT;
        int ingredientsWidth = columns * INGREDIENT_WIDTH;
        int width = Math.max(ingredientsWidth, minWidth);
        int height = rows * INGREDIENT_HEIGHT;
        int x = availableArea.x + (availableArea.width - width);
        int y = availableArea.y + (availableArea.height - height) / 2;
        int xOffset = x + Math.max(0, (width - ingredientsWidth) / 2);
        this.getArea().setBounds(x, y, width, height);
        this.guiIngredientSlots.clear();
        this.guiHistoryIngredientSlots.clear();
        this.historySize = columns * 2;
        if (rows == 0 || columns < 4) {
            return false;
        }
        if (rows >= 6) {
            rows -= 2;
            this.showHistory = true;
        } else {
            this.showHistory = false;
        }
        for (row = 0; row < rows; ++row) {
            y1 = y + row * INGREDIENT_HEIGHT;
            for (column = 0; column < columns; ++column) {
                x1 = xOffset + column * INGREDIENT_WIDTH;
                ingredientListSlot = new IngredientListSlot(x1, y1, 1);
                stackArea = ingredientListSlot.getArea();
                blocked = MathUtil.intersects(exclusionAreas, (Rectangle)stackArea);
                ingredientListSlot.setBlocked(blocked);
                this.guiIngredientSlots.add(ingredientListSlot);
            }
        }
        if (this.showHistory) {
            for (row = 0; row < 2; ++row) {
                y1 = y + (row + rows) * INGREDIENT_HEIGHT;
                for (column = 0; column < columns; ++column) {
                    x1 = xOffset + column * INGREDIENT_WIDTH;
                    ingredientListSlot = new IngredientListSlot(x1, y1, 1);
                    stackArea = ingredientListSlot.getArea();
                    blocked = MathUtil.intersects(exclusionAreas, (Rectangle)stackArea);
                    ingredientListSlot.setBlocked(blocked);
                    this.guiHistoryIngredientSlots.add(ingredientListSlot);
                }
            }
            this.guiHistoryIngredientSlots.set(0, this.historyIngredientElements);
        }
        return true;
    }

    public void draw(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        GlStateManager.func_179084_k();
        this.guiIngredientSlots.render(minecraft);
        if (this.showHistory) {
            Rectangle firstRect = ((IngredientListSlot)this.guiHistoryIngredientSlots.getAllGuiIngredientSlots().get(0)).getArea();
            if (JeiUtilitiesConfig.getSplittingMode() == SplittingMode.DOTTED_LINE) {
                this.drawSpillingArea(firstRect.x, firstRect.y, firstRect.width * this.columns, firstRect.height * 2, JeiUtilitiesConfig.getBackgroundColour());
            } else {
                GuiUtils.drawGradientRect((int)0, (int)firstRect.x, (int)firstRect.y, (int)(firstRect.x + firstRect.width * this.columns), (int)(firstRect.y + firstRect.height * 2), (int)JeiUtilitiesConfig.getBackgroundColour(), (int)JeiUtilitiesConfig.getBackgroundColour());
            }
            this.guiHistoryIngredientSlots.render(minecraft);
        }
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY) && this.isMouseOver(mouseX, mouseY)) {
            IngredientRenderer hoveredHistory;
            IngredientRenderer hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY);
            if (hovered != null) {
                hovered.drawHighlight();
            }
            if (this.showHistory && (hoveredHistory = this.guiHistoryIngredientSlots.getHovered(mouseX, mouseY)) != null) {
                hoveredHistory.drawHighlight();
            }
        }
        GlStateManager.func_179141_d();
    }

    public void drawTooltips(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                String deleteItem = Translator.translateToLocal((String)"jei.tooltip.delete.item");
                TooltipRenderer.drawHoveringText((Minecraft)minecraft, (String)deleteItem, (int)mouseX, (int)mouseY);
            } else {
                IngredientRenderer hoveredHistory;
                IngredientRenderer hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY);
                if (hovered != null) {
                    hovered.drawTooltip(minecraft, mouseX, mouseY);
                }
                if (this.showHistory && (hoveredHistory = this.getGuiHistoryIngredientSlots().getHovered(mouseX, mouseY)) != null) {
                    hoveredHistory.drawTooltip(minecraft, mouseX, mouseY);
                }
            }
        }
    }

    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        IClickedIngredient clicked = super.getIngredientUnderMouse(mouseX, mouseY);
        if (clicked != null) {
            return clicked;
        }
        if (this.showHistory) {
            ClickedIngredient clickedHistory = this.guiHistoryIngredientSlots.getIngredientUnderMouse(mouseX, mouseY);
            if (clickedHistory != null) {
                clickedHistory.setAllowsCheating();
            }
            return clickedHistory;
        }
        return null;
    }

    private boolean shouldDeleteItemOnClick(Minecraft minecraft, int mouseX, int mouseY) {
        JeiRuntime runtime;
        ItemStack itemStack;
        EntityPlayerSP player;
        if (!(!Config.isDeleteItemsInCheatModeActive() || (player = minecraft.field_71439_g) == null || (itemStack = player.field_71071_by.func_70445_o()).func_190926_b() || (runtime = Internal.getRuntime()) != null && runtime.getRecipesGui().isOpen())) {
            IClickedIngredient<?> ingredientUnderMouse;
            GiveMode giveMode = Config.getGiveMode();
            if (giveMode == GiveMode.MOUSE_PICKUP && (ingredientUnderMouse = this.getIngredientUnderMouse(mouseX, mouseY)) != null && ingredientUnderMouse.getValue() instanceof ItemStack) {
                ItemStack value = (ItemStack)ingredientUnderMouse.getValue();
                return !ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)value);
            }
            return true;
        }
        return false;
    }

    public IngredientListBatchRenderer getGuiHistoryIngredientSlots() {
        return this.guiHistoryIngredientSlots;
    }

    public void addHistoryIngredient(Object value) {
        if (value != null) {
            if (value instanceof RecipeInfo) {
                return;
            }
            Object normalized = IngredientHelper.getNormalize(value);
            IngredientListElement ingredient = IngredientListElement.create((Object)normalized, (IIngredientHelper)JeiUtilitiesPlugin.ingredientRegistry.getIngredientHelper(normalized), (IIngredientRenderer)JeiUtilitiesPlugin.ingredientRegistry.getIngredientRenderer(normalized), (IModIdHelper)ForgeModIdHelper.getInstance(), (int)JeiUtilitiesPlugin.ORDER_TRACKER.getOrderIndex(normalized, JeiUtilitiesPlugin.ingredientRegistry.getIngredientHelper(normalized)));
            this.historyIngredientElements.removeIf(element -> this.areIngredientEqual(element.getIngredient(), normalized, JeiUtilitiesConfig.isMatchesNBTs()));
            this.historyIngredientElements.add(0, (IIngredientListElement)ingredient);
            if (this.historyIngredientElements.size() > this.historySize) {
                this.historyIngredientElements.remove(this.historyIngredientElements.size() - 1);
            }
            while (this.historyIngredientElements.size() > 200) {
                this.historyIngredientElements.remove(this.historyIngredientElements.size() - 1);
            }
            this.guiHistoryIngredientSlots.set(0, this.historyIngredientElements);
        }
    }

    public void removeElement(int index) {
        this.historyIngredientElements.remove(index);
        this.guiHistoryIngredientSlots.set(0, this.historyIngredientElements);
    }

    private boolean areIngredientEqual(@Nonnull Object ingredient1, @Nonnull Object ingredient2, boolean matchesNbt) {
        if (ingredient1 == ingredient2) {
            return true;
        }
        if (ingredient1.getClass() == ingredient2.getClass()) {
            IIngredientHelper ingredientHelper = JeiUtilitiesPlugin.ingredientRegistry.getIngredientHelper(ingredient1);
            if (matchesNbt) {
                return ingredientHelper.getUniqueId(ingredient1).equals(ingredientHelper.getUniqueId(ingredient2));
            }
            return ingredientHelper.getWildcardId(ingredient1).equals(ingredientHelper.getWildcardId(ingredient2));
        }
        return false;
    }

    private void drawSpillingArea(int x, int y, int width, int height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GL11.glEnable((int)2852);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glLineWidth((float)2.0f);
        GL11.glLineStipple((int)2, (short)255);
        GL11.glBegin((int)2);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glEnd();
        GL11.glLineStipple((int)2, (short)-1);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)2852);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private boolean isIgnoredIngredients() {
        return false;
    }
}

