/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.tool;

import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.location.TileLocation;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.ingredient.NotEnoughIngredientsException;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class LittleActionGlowstone
extends LittleActionInteract {
    public TileLocation changedTile;

    public LittleActionGlowstone(World world, BlockPos blockPos, EntityPlayer player) {
        super(world, blockPos, player);
    }

    public LittleActionGlowstone() {
    }

    @Override
    protected boolean isRightClick() {
        return true;
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, IParentTileList parent, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (stack.func_77973_b() == Items.field_151114_aO && player.func_70093_af()) {
            if (LittleActionGlowstone.needIngredients(player)) {
                if (tile.glowing) {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151114_aO))) {
                        player.func_71019_a(new ItemStack(Items.field_151114_aO), true);
                    }
                } else {
                    stack.func_190918_g(1);
                }
            }
            if (tile.glowing) {
                player.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            } else {
                player.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
            }
            tile.glowing = !tile.glowing;
            te.updateTiles();
            te.updateLighting();
            this.changedTile = new TileLocation(parent, tile);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(EntityPlayer player) throws LittleActionException {
        if (this.changedTile.find(player.field_70170_p) != null) {
            return new LittleActionGlowstoneRevert(this.changedTile);
        }
        throw new LittleActionException.TileNotThereException();
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        return null;
    }

    public static class LittleActionGlowstoneRevert
    extends LittleAction {
        public TileLocation location;
        public TileLocation newLocation;

        public LittleActionGlowstoneRevert(TileLocation location) {
            this.location = location;
        }

        public LittleActionGlowstoneRevert() {
        }

        @Override
        public boolean canBeReverted() {
            return true;
        }

        @Override
        public LittleAction revert(EntityPlayer player) throws LittleActionException {
            if (this.location.find(player.field_70170_p) != null) {
                return new LittleActionGlowstoneRevert(this.newLocation);
            }
            throw new LittleActionException.TileNotThereException();
        }

        @Override
        protected boolean action(EntityPlayer player) throws LittleActionException {
            ItemStack stack;
            Pair<IParentTileList, LittleTile> pair = this.newLocation.find(player.field_70170_p);
            LittleTile tile = (LittleTile)pair.value;
            if (LittleActionGlowstoneRevert.needIngredients(player) && !InventoryUtils.consumeItemStack((IInventory)player.field_71071_by, (ItemStack)(stack = new ItemStack(Items.field_151114_aO)))) {
                throw new NotEnoughIngredientsException.NotEnoughSpaceException(stack);
            }
            if (tile.glowing) {
                player.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            } else {
                player.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
            }
            tile.glowing = !tile.glowing;
            ((IParentTileList)pair.key).getTe().updateTiles();
            ((IParentTileList)pair.key).getTe().updateLighting();
            this.newLocation = new TileLocation((IParentTileList)pair.key, tile);
            return false;
        }

        public void writeBytes(ByteBuf buf) {
            LittleActionGlowstoneRevert.writeTileLocation(this.location, buf);
        }

        public void readBytes(ByteBuf buf) {
            this.location = LittleActionGlowstoneRevert.readTileLocation(buf);
        }

        @Override
        public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
            return null;
        }
    }
}

