/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.container;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import com.creativemd.littletiles.common.recipe.WhitenRecipeRegistry;
import com.creativemd.littletiles.common.structure.type.premade.LittleWhitener;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerWhitener
extends SubContainer {
    public LittleWhitener whitener;
    public InventoryBasic whiteInput = new InventoryBasic("whiteInput", false, 1);

    public SubContainerWhitener(EntityPlayer player, LittleWhitener whitener) {
        super(player);
        this.whitener = whitener;
        this.updateVolume();
    }

    public void createControls() {
        this.addSlotToContainer(new Slot((IInventory)this.whitener.inventory, 0, 8, 10){

            public boolean func_75214_a(ItemStack stack) {
                return !WhitenRecipeRegistry.getRecipe(stack).isEmpty();
            }
        });
        this.addSlotToContainer(new Slot((IInventory)this.whiteInput, 0, 8, 40){

            public boolean func_75214_a(ItemStack stack) {
                return WhitenRecipeRegistry.getVolume(stack) > 0;
            }
        });
        this.addPlayerSlotsToContainer(this.player);
    }

    @CustomEventSubscribe
    public void slotChanged(SlotChangeEvent event) {
        int volume = WhitenRecipeRegistry.getVolume(this.whiteInput.func_70301_a(0));
        if (volume > 0) {
            ItemStack stack = this.whiteInput.func_70301_a(0);
            boolean added = false;
            while (!stack.func_190926_b() && volume + this.whitener.whiteColor <= WhitenRecipeRegistry.whitenerTotalVolume) {
                stack.func_190918_g(1);
                this.whitener.whiteColor += volume;
                added = true;
            }
            if (added) {
                this.player.func_184185_a(SoundEvents.field_187621_J, 1.0f, 1.0f);
            }
            this.updateVolume();
        }
    }

    public void updateVolume() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("volume", this.whitener.whiteColor);
        this.sendNBTToGui(nbt);
    }

    public void onPacketReceive(NBTTagCompound nbt) {
        if (nbt.func_74767_n("craft")) {
            List<WhitenRecipeRegistry.WhitenRecipe> recipes;
            int amount = nbt.func_74762_e("amount");
            ItemStack stack = this.whitener.inventory.func_70301_a(0);
            int stackSize = 1;
            if (amount > 1) {
                stackSize = stack.func_190916_E();
            }
            if (!(recipes = WhitenRecipeRegistry.getRecipe(stack)).isEmpty()) {
                boolean result;
                int index = 0;
                int variant = nbt.func_74762_e("variant");
                WhitenRecipeRegistry.WhitenRecipe selected = null;
                IBlockState state = null;
                for (WhitenRecipeRegistry.WhitenRecipe recipe : recipes) {
                    if (variant >= index + recipe.results.length) {
                        index += recipe.results.length;
                        continue;
                    }
                    selected = recipe;
                    state = recipe.results[variant - index];
                    break;
                }
                if (selected == null) {
                    return;
                }
                boolean bl = result = !selected.isResult(stack);
                if (result && selected.needed > 0) {
                    stackSize = Math.min(stackSize, this.whitener.whiteColor / selected.needed);
                }
                ItemStack newStack = new ItemStack(state.func_177230_c(), stackSize, state.func_177230_c().func_176201_c(state));
                stack.func_190918_g(stackSize);
                if (!this.player.func_191521_c(newStack)) {
                    this.player.func_71019_a(newStack, false);
                }
                if (result && selected.needed > 0) {
                    this.whitener.whiteColor -= stackSize * selected.needed;
                }
                this.updateVolume();
            }
        }
    }
}

