/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleAnimationDestroyPacket;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class LittleAnimationDataPacket
extends CreativeCorePacket {
    public UUID uuid;
    public NBTTagCompound nbt;
    public boolean enteredAsChild;

    public LittleAnimationDataPacket(UUID uuid, NBTTagCompound nbt, boolean enteredAsChild) {
        this.uuid = uuid;
        this.nbt = nbt;
        this.enteredAsChild = enteredAsChild;
    }

    public LittleAnimationDataPacket(EntityAnimation animation) {
        this(animation.func_110124_au(), animation.func_189511_e(new NBTTagCompound()), animation.enteredAsChild);
    }

    public LittleAnimationDataPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAnimationDataPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        LittleAnimationDataPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
        buf.writeBoolean(this.enteredAsChild);
    }

    public void readBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(LittleAnimationDataPacket.readString((ByteBuf)buf));
        this.nbt = LittleAnimationDataPacket.readNBT((ByteBuf)buf);
        this.enteredAsChild = buf.readBoolean();
    }

    public void executeClient(EntityPlayer player) {
        EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.uuid);
        if (animation != null) {
            this.updateAnimation(animation);
            return;
        }
        for (Entity entity : player.field_70170_p.func_175644_a(EntityAnimation.class, (Predicate)new Predicate<EntityAnimation>(){

            public boolean apply(EntityAnimation input) {
                return true;
            }
        })) {
            if (!(entity instanceof EntityAnimation) || !entity.func_110124_au().equals(this.uuid)) continue;
            animation = (EntityAnimation)entity;
            this.updateAnimation(animation);
            if (!animation.isDoorAdded()) {
                animation.addDoor();
            }
            return;
        }
        System.out.println("Entity not found!");
    }

    public void updateAnimation(EntityAnimation animation) {
        animation.field_70128_L = false;
        if (!this.enteredAsChild || animation.enteredAsChild != this.enteredAsChild) {
            animation.func_70020_e(this.nbt);
            animation.updateTickState();
        }
    }

    public void executeServer(EntityPlayer player) {
        EntityAnimation animation = WorldAnimationHandler.findAnimation(false, this.uuid);
        if (animation != null) {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleAnimationDataPacket(animation), (EntityPlayerMP)((EntityPlayerMP)player));
        } else {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleAnimationDestroyPacket(this.uuid, false), (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }
}

