/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleBlocksUpdatePacket
extends CreativeCorePacket {
    public List<BlockPos> positions;
    public List<IBlockState> states;
    public List<SPacketUpdateTileEntity> packets;
    public UUID uuid;

    public LittleBlocksUpdatePacket(World world, Iterable<? extends TileEntity> tileEntities) {
        this.positions = new ArrayList<BlockPos>();
        this.states = new ArrayList<IBlockState>();
        this.packets = new ArrayList<SPacketUpdateTileEntity>();
        for (TileEntity tileEntity : tileEntities) {
            this.positions.add(tileEntity.func_174877_v());
            this.states.add(world.func_180495_p(tileEntity.func_174877_v()));
            this.packets.add(tileEntity.func_189518_D_());
        }
        if (world instanceof CreativeWorld) {
            this.uuid = ((CreativeWorld)world).parent.func_110124_au();
        }
    }

    public LittleBlocksUpdatePacket() {
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeInt(this.positions.size());
        for (int i = 0; i < this.positions.size(); ++i) {
            LittleBlocksUpdatePacket.writePos((ByteBuf)buf, (BlockPos)this.positions.get(i));
            LittleBlocksUpdatePacket.writeState((ByteBuf)buf, (IBlockState)this.states.get(i));
            if (this.packets.get(i) != null) {
                buf.writeBoolean(true);
                LittleBlocksUpdatePacket.writePacket((ByteBuf)buf, (Packet)((Packet)this.packets.get(i)));
                continue;
            }
            buf.writeBoolean(false);
        }
        if (this.uuid != null) {
            buf.writeBoolean(true);
            LittleBlocksUpdatePacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.positions = new ArrayList<BlockPos>(size);
        this.states = new ArrayList<IBlockState>(size);
        this.packets = new ArrayList<SPacketUpdateTileEntity>(size);
        for (int i = 0; i < size; ++i) {
            this.positions.add(LittleBlocksUpdatePacket.readPos((ByteBuf)buf));
            this.states.add(LittleBlocksUpdatePacket.readState((ByteBuf)buf));
            if (buf.readBoolean()) {
                this.packets.add((SPacketUpdateTileEntity)LittleBlocksUpdatePacket.readPacket((ByteBuf)buf));
                continue;
            }
            this.packets.add(null);
        }
        this.uuid = buf.readBoolean() ? UUID.fromString(LittleBlocksUpdatePacket.readString((ByteBuf)buf)) : null;
    }

    public void executeClient(EntityPlayer player) {
        World world = player.field_70170_p;
        if (this.uuid != null) {
            EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.uuid);
            if (animation == null) {
                return;
            }
            world = animation.fakeWorld;
        }
        for (int i = 0; i < this.positions.size(); ++i) {
            if (world instanceof WorldClient) {
                ((WorldClient)world).func_180503_b(this.positions.get(i), this.states.get(i));
                if (this.packets.get(i) == null) continue;
                ((EntityPlayerSP)player).field_71174_a.func_147273_a(this.packets.get(i));
                continue;
            }
            world.func_180501_a(this.positions.get(i), this.states.get(i), 3);
            TileEntity te = world.func_175625_s(this.positions.get(i));
            if (this.packets.get(i) == null) continue;
            te.onDataPacket(((EntityPlayerSP)player).field_71174_a.func_147298_b(), this.packets.get(i));
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

