/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class LittleEntityFixControllerPacket
extends CreativeCorePacket {
    public UUID uuid;
    public NBTTagCompound nbt;

    public LittleEntityFixControllerPacket(UUID uuid, NBTTagCompound nbt) {
        this.uuid = uuid;
        this.nbt = nbt;
    }

    public LittleEntityFixControllerPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleEntityFixControllerPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        LittleEntityFixControllerPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public void readBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(LittleEntityFixControllerPacket.readString((ByteBuf)buf));
        this.nbt = LittleEntityFixControllerPacket.readNBT((ByteBuf)buf);
    }

    public void executeClient(EntityPlayer player) {
        EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.uuid);
        if (animation != null) {
            if (this.nbt.func_74767_n("animationHasBeenRemoved")) {
                animation.destroyAnimation();
                return;
            }
            animation.controller = DoorController.parseController(animation, this.nbt);
            animation.updateTickState();
            return;
        }
        for (Entity entity : player.field_70170_p.func_175644_a(EntityAnimation.class, (Predicate)new Predicate<EntityAnimation>(){

            public boolean apply(EntityAnimation input) {
                return true;
            }
        })) {
            if (!(entity instanceof EntityAnimation) || !entity.func_110124_au().equals(this.uuid)) continue;
            animation = (EntityAnimation)entity;
            if (this.nbt.func_74767_n("animationHasBeenRemoved")) {
                animation.destroyAnimation();
                return;
            }
            animation.controller = DoorController.parseController(animation, this.nbt);
            animation.updateTickState();
            return;
        }
    }

    public void executeServer(EntityPlayer player) {
        EntityAnimation animation = WorldAnimationHandler.findAnimation(false, this.uuid);
        if (animation != null) {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityFixControllerPacket(this.uuid, animation.controller.writeToNBT(new NBTTagCompound())), (EntityPlayerMP)((EntityPlayerMP)player));
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("animationHasBeenRemoved", true);
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityFixControllerPacket(this.uuid, nbt), (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }
}

