/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.input;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.SignalUtils;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalLogicOperator;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import com.creativemd.littletiles.common.structure.signal.logic.SignalTarget;
import java.text.ParseException;
import java.util.ArrayList;

public class SignalInputVariable
extends SignalInputCondition {
    public final SignalTarget target;

    private static int[] parseInputExact(SignalPatternParser parser) throws ParseException {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (parser.hasNext()) {
            char next = parser.lookForNext(true);
            if (next == '}') {
                parser.next(true);
                break;
            }
            if (Character.isDigit(next) || next == '*') {
                if (next == '*') {
                    indexes.add(2);
                    next = parser.next(true);
                    if (next != '}') continue;
                    break;
                }
                indexes.add(Integer.parseInt("" + next));
                next = parser.next(true);
                if (next != '}') continue;
                break;
            }
            throw parser.invalidChar(next);
        }
        if (indexes.isEmpty()) {
            return null;
        }
        int[] result = new int[indexes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)indexes.get(i);
        }
        return result;
    }

    public static SignalInputVariable parseInput(SignalPatternParser parser, boolean insideVariable) throws ParseException {
        SignalTarget target = SignalTarget.parseTarget(parser, false, insideVariable);
        if (!insideVariable && parser.lookForNext(false) == '{') {
            parser.next(false);
            char next = parser.lookForNext(true);
            if (Character.isDigit(next) || next == '*') {
                int[] indexes = SignalInputVariable.parseInputExact(parser);
                if (indexes != null) {
                    return new SignalInputVariablePattern(target, indexes);
                }
                return new SignalInputVariable(target);
            }
            SignalLogicOperator operator = SignalLogicOperator.getOperator(next);
            if (operator != null) {
                parser.next(true);
                if (parser.next(true) == '}') {
                    return new SignalInputVariableOperator(target, operator);
                }
                throw parser.invalidChar(parser.current());
            }
            return new SignalInputVariableEquation(target, SignalInputCondition.parseExpression(parser, new char[]{'}'}, false, true));
        }
        return new SignalInputVariable(target);
    }

    public SignalInputVariable(SignalTarget target) {
        this.target = target;
    }

    @Override
    public boolean[] test(LittleStructure structure, boolean forceBitwise) {
        boolean[] state = this.target.getState(structure);
        if (forceBitwise) {
            return state;
        }
        return BooleanUtils.asArray((boolean)BooleanUtils.any((boolean[])state));
    }

    @Override
    public boolean testIndex(boolean[] state) {
        if (this.target.isIndexVariable() && this.target.child < state.length) {
            return state[this.target.child];
        }
        return false;
    }

    @Override
    public String write() {
        return this.target.write();
    }

    @Override
    public float calculateDelay() {
        return 0.01f;
    }

    public static class SignalInputVariableEquation
    extends SignalInputVariable {
        public final SignalInputCondition condition;

        public SignalInputVariableEquation(SignalTarget target, SignalInputCondition condition) {
            super(target);
            this.condition = condition;
        }

        @Override
        public boolean[] test(LittleStructure structure, boolean forceBitwise) {
            return BooleanUtils.asArray((boolean)this.condition.testIndex(this.target.getState(structure)));
        }

        @Override
        public String write() {
            return super.write() + "{" + this.condition.write() + "}";
        }

        @Override
        public float calculateDelay() {
            return super.calculateDelay() + this.condition.calculateDelay();
        }
    }

    public static class SignalInputVariablePattern
    extends SignalInputVariable {
        public final int[] indexes;

        public SignalInputVariablePattern(SignalTarget target, int[] indexes) {
            super(target);
            this.indexes = indexes;
        }

        @Override
        public boolean[] test(LittleStructure structure, boolean forceBitwise) {
            return BooleanUtils.asArray((boolean)SignalUtils.is(this.target.getState(structure), this.indexes));
        }

        @Override
        public String write() {
            String result = super.write() + "{";
            for (int i = 0; i < this.indexes.length; ++i) {
                int index = this.indexes[i];
                result = result + "" + (index >= 2 ? "*" : Integer.valueOf(index));
            }
            return result + "}";
        }
    }

    public static class SignalInputVariableOperator
    extends SignalInputVariable {
        public final SignalLogicOperator operator;

        public SignalInputVariableOperator(SignalTarget target, SignalLogicOperator operator) {
            super(target);
            this.operator = operator;
        }

        @Override
        public boolean[] test(LittleStructure structure, boolean forceBitwise) {
            boolean[] state = this.target.getState(structure);
            boolean result = false;
            for (int i = 0; i < state.length; ++i) {
                result = i == 0 ? state[i] : this.operator.perform(result, state[i]);
            }
            return BooleanUtils.asArray((boolean)result);
        }

        @Override
        public String write() {
            return super.write() + "{" + (this.operator == SignalLogicOperator.AND ? "&" : Character.valueOf(this.operator.operator)) + "}";
        }
    }
}

