/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.door;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.littletiles.client.gui.controls.GuiDirectionIndicator;
import com.creativemd.littletiles.client.gui.controls.GuiLTDistance;
import com.creativemd.littletiles.client.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.animation.AnimationKey;
import com.creativemd.littletiles.common.structure.animation.AnimationState;
import com.creativemd.littletiles.common.structure.animation.AnimationTimeline;
import com.creativemd.littletiles.common.structure.animation.ValueTimeline;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.Placement;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSlidingDoor
extends LittleDoorBase {
    @StructureDirectional
    public EnumFacing direction;
    public int moveDistance;
    public LittleGridContext moveContext;

    public LittleSlidingDoor(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.moveDistance = nbt.func_74762_e("distance");
        this.moveContext = LittleGridContext.get(nbt);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        nbt.func_74768_a("distance", this.moveDistance);
        this.moveContext.set(nbt);
    }

    @Override
    public DoorController createController(UUIDSupplier supplier, Placement placement, int completeDuration) {
        return new DoorController(supplier, new AnimationState(), new AnimationState().set(AnimationKey.getOffset(this.direction.func_176740_k()), (double)this.direction.func_176743_c().func_179524_a() * this.moveContext.toVanillaGrid(this.moveDistance)), this.stayAnimated ? null : Boolean.valueOf(false), this.duration, completeDuration, this.interpolation);
    }

    @Override
    public void transformDoorPreview(LittleAbsolutePreviews previews) {
    }

    @Override
    public StructureAbsolute getAbsoluteAxis() {
        return new StructureAbsolute(this.getPos(), new LittleBox(0, 0, 0, 1, 1, 1), this.mainBlock.getContext());
    }

    public static class LittleSlidingDoorParser
    extends LittleDoorBase.LittleDoorBaseParser {
        public LittleSlidingDoorParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @SideOnly(value=Side.CLIENT)
        @CustomEventSubscribe
        public void buttonClicked(GuiControlClickEvent event) {
            if (event.source.is(new String[]{"direction"})) {
                GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
                EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)event.source).getState());
                GuiDirectionIndicator relativeDirection = (GuiDirectionIndicator)this.parent.get("relativeDirection");
                this.updateButtonDirection(viewer, direction, relativeDirection);
            }
        }

        @Override
        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onChanged(GuiControlChangedEvent event) {
            super.onChanged(event);
            if (event.source.is(new String[]{"distance"})) {
                this.updateTimeline();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static void updateDirection(GuiTileViewer viewer, EnumFacing direction, GuiDirectionIndicator relativeDirection) {
            EnumFacing newDirection = EnumFacing.EAST;
            if (viewer.getXFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getXFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.EAST : EnumFacing.WEST;
            } else if (viewer.getYFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getYFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.DOWN : EnumFacing.UP;
            } else if (viewer.getZFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getZFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
            relativeDirection.setDirection(newDirection);
        }

        @SideOnly(value=Side.CLIENT)
        public void updateButtonDirection(GuiTileViewer viewer, EnumFacing direction, GuiDirectionIndicator relativeDirection) {
            LittleSlidingDoorParser.updateDirection(viewer, direction, relativeDirection);
            this.updateTimeline();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, @Nullable LittleStructure structure) {
            LittleSlidingDoor door = null;
            if (structure instanceof LittleSlidingDoor) {
                door = (LittleSlidingDoor)structure;
            }
            LittleVec size = previews.getSize();
            int index = EnumFacing.UP.ordinal();
            if (door != null) {
                index = door.direction.ordinal();
            }
            final EnumFacing direction = EnumFacing.func_82600_a((int)index);
            LittleGridContext context = previews.getContext();
            final GuiTileViewer viewer = new GuiTileViewer("tileviewer", 0, 0, 100, 100, context);
            viewer.visibleAxis = false;
            this.parent.addControl((GuiControl)viewer);
            this.parent.addControl((GuiControl)new GuiStateButton("direction", index, 110, 0, 37, 12, RotationUtils.getFacingNames()));
            final GuiDirectionIndicator relativeDirection = new GuiDirectionIndicator("relativeDirection", 155, 0, EnumFacing.UP);
            this.parent.addControl((GuiControl)relativeDirection);
            int distance = size.get(direction.func_176740_k());
            if (door != null) {
                distance = door.moveDistance;
                context = door.moveContext;
            }
            this.parent.addControl((GuiControl)new GuiLTDistance("distance", 110, 21, context, distance));
            this.parent.addControl(new GuiIconButton("reset view", 20, 107, 8){

                public void onClicked(int x, int y, int button) {
                    viewer.offsetX.set(0.0);
                    viewer.offsetY.set(0.0);
                    viewer.scale.set(40.0);
                }
            }.setCustomTooltip(new String[]{"reset view"}));
            this.parent.addControl(new GuiIconButton("change view", 40, 107, 7){

                public void onClicked(int x, int y, int button) {
                    switch (viewer.getAxis()) {
                        case X: {
                            viewer.setViewAxis(EnumFacing.Axis.Y);
                            break;
                        }
                        case Y: {
                            viewer.setViewAxis(EnumFacing.Axis.Z);
                            break;
                        }
                        case Z: {
                            viewer.setViewAxis(EnumFacing.Axis.X);
                            break;
                        }
                    }
                    this.updateButtonDirection(viewer, direction, relativeDirection);
                }
            }.setCustomTooltip(new String[]{"change view"}));
            this.parent.addControl(new GuiIconButton("flip view", 60, 107, 4){

                public void onClicked(int x, int y, int button) {
                    viewer.setViewDirection(viewer.getViewDirection().func_176734_d());
                    LittleSlidingDoorParser.updateDirection(viewer, direction, relativeDirection);
                }
            }.setCustomTooltip(new String[]{"flip view"}));
            super.createControls(previews, structure);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleSlidingDoor parseStructure() {
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)this.parent.get("direction")).getState());
            GuiLTDistance distance = (GuiLTDistance)this.parent.get("distance");
            LittleSlidingDoor door = this.createStructure(LittleSlidingDoor.class, null);
            door.direction = direction;
            door.moveDistance = distance.getDistance();
            door.moveContext = distance.getDistanceContext();
            return door;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onLoaded(AnimationPreview animationPreview) {
            super.onLoaded(animationPreview);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            GuiDirectionIndicator relativeDirection = (GuiDirectionIndicator)this.parent.get("relativeDirection");
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)this.parent.get("direction")).getState());
            this.updateButtonDirection(viewer, direction, relativeDirection);
        }

        @Override
        public void populateTimeline(AnimationTimeline timeline, int interpolation) {
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)this.parent.get("direction")).getState());
            GuiLTDistance distance = (GuiLTDistance)this.parent.get("distance");
            timeline.values.add((Object)AnimationKey.getOffset(direction.func_176740_k()), (Object)ValueTimeline.create(interpolation).addPoint(0, 0.0).addPoint(timeline.duration, (double)direction.func_176743_c().func_179524_a() * distance.getDistanceContext().toVanillaGrid(distance.getDistance())));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleSlidingDoor.class);
        }
    }
}

